/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.session;

import io.manbang.ebatis.core.cluster.Cluster;
import io.manbang.ebatis.core.domain.Page;
import io.manbang.ebatis.core.domain.Pageable;
import io.manbang.ebatis.core.request.CatRequest;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.session.CachedClusterSession;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;

public interface ClusterSession
extends Cloneable {
    public static ClusterSession of(Cluster cluster) {
        return CachedClusterSession.createOrGet(cluster);
    }

    public <T> CompletableFuture<T> getAsync(GetRequest var1, ResponseExtractor<T> var2);

    default public <T> T getSync(GetRequest request, ResponseExtractor<T> extractor) {
        return this.getAsync(request, extractor).join();
    }

    public <T> CompletableFuture<T> deleteAsync(DeleteRequest var1, ResponseExtractor<T> var2);

    default public <T> T deleteSync(DeleteRequest request, ResponseExtractor<T> extractor) {
        return this.deleteAsync(request, extractor).join();
    }

    public <T> CompletableFuture<T> deleteByQueryAsync(DeleteByQueryRequest var1, ResponseExtractor<T> var2);

    default public <T> T deleteByQuerySync(DeleteByQueryRequest request, ResponseExtractor<T> extractor) {
        return this.deleteByQueryAsync(request, extractor).join();
    }

    public <T> CompletableFuture<T> updateAsync(UpdateRequest var1, ResponseExtractor<T> var2);

    default public <T> T updateSync(UpdateRequest request, ResponseExtractor<T> extractor) {
        return this.updateAsync(request, extractor).join();
    }

    public <T> CompletableFuture<T> updateByQueryAsync(UpdateByQueryRequest var1, ResponseExtractor<T> var2);

    default public <T> T updateByQuerySync(UpdateByQueryRequest request, ResponseExtractor<T> extractor) {
        return this.updateByQueryAsync(request, extractor).join();
    }

    public <T> CompletableFuture<T> indexAsync(IndexRequest var1, ResponseExtractor<T> var2);

    default public <T> T indexSync(IndexRequest request, ResponseExtractor<T> extractor) {
        return this.indexAsync(request, extractor).join();
    }

    public <T> CompletableFuture<T> multiSearchAsync(MultiSearchRequest var1, ResponseExtractor<T> var2);

    default public <T> T multiSearchSync(MultiSearchRequest request, ResponseExtractor<T> extractor) {
        return this.multiSearchAsync(request, extractor).join();
    }

    public <T> CompletableFuture<T> multiSearchAsync(MultiSearchRequest var1, ResponseExtractor<T> var2, Pageable[] var3);

    default public <T> T multiSearchSync(MultiSearchRequest request, ResponseExtractor<T> extractor, Pageable[] pageable) {
        return this.multiSearchAsync(request, extractor, pageable).join();
    }

    public <T> CompletableFuture<T> searchAsync(SearchRequest var1, ResponseExtractor<T> var2);

    default public <T> T searchSync(SearchRequest request, ResponseExtractor<T> extractor) {
        return this.searchAsync(request, extractor).join();
    }

    public <T> CompletableFuture<Page<T>> searchAsync(SearchRequest var1, ResponseExtractor<Page<T>> var2, Pageable var3);

    default public <T> Page<T> searchSync(SearchRequest request, ResponseExtractor<Page<T>> extractor, Pageable pageable) {
        return this.searchAsync(request, extractor, pageable).join();
    }

    default public <T> T bulkSync(BulkRequest request, ResponseExtractor<T> extractor) {
        return this.bulkAsync(request, extractor).join();
    }

    public <T> CompletableFuture<T> bulkAsync(BulkRequest var1, ResponseExtractor<T> var2);

    public <T> CompletableFuture<T> catAsync(CatRequest var1, ResponseExtractor<T> var2);

    default public <T> T catSync(CatRequest request, ResponseExtractor<T> extractor) {
        return this.catAsync(request, extractor).join();
    }

    public <T> CompletableFuture<T> scrollAsync(SearchScrollRequest var1, ResponseExtractor<T> var2);

    public <T> CompletableFuture<T> clearScrollAsync(ClearScrollRequest var1, ResponseExtractor<T> var2);

    public <T> CompletableFuture<T> mgetAsync(MultiGetRequest var1, ResponseExtractor<T> var2);

    public <T> T getMapper(Class<T> var1);

    public Cluster getCluster();
}

