/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import com.google.auto.service.AutoService;
import io.manbang.ebatis.core.common.ObjectMapperHolder;
import io.manbang.ebatis.core.exception.DocumentDeserializeException;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.response.AbstractResponseExtractorProvider;
import io.manbang.ebatis.core.response.RawResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorProvider;
import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.action.get.GetResponse;

@AutoService(value={ResponseExtractorProvider.class})
public class GetResponseExtractorProvider
extends AbstractResponseExtractorProvider {
    public GetResponseExtractorProvider() {
        super(RequestType.GET);
    }

    @Override
    protected ResponseExtractor<?> getResponseExtractor(MethodMeta meta, GenericType genericType) {
        Class<?> resultClass = genericType.resolve();
        if (resultClass == GetResponse.class) {
            return RawResponseExtractor.INSTANCE;
        }
        if (resultClass == Optional.class) {
            Class<?> entityClass = genericType.resolveGeneric(0);
            return response -> {
                try {
                    if (response.isExists()) {
                        return Optional.ofNullable(ObjectMapperHolder.objectMapper().readValue(response.getSourceAsBytes(), entityClass));
                    }
                    return Optional.empty();
                }
                catch (IOException e) {
                    throw new DocumentDeserializeException(e);
                }
            };
        }
        return response -> {
            try {
                if (response.isExists()) {
                    return ObjectMapperHolder.objectMapper().readValue(response.getSourceAsBytes(), resultClass);
                }
                return null;
            }
            catch (IOException e) {
                throw new DocumentDeserializeException(e);
            }
        };
    }
}

