/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import io.manbang.ebatis.core.exception.FieldMetaNotFoundException;
import io.manbang.ebatis.core.meta.AnnotatedMeta;
import io.manbang.ebatis.core.meta.ClassMeta;
import io.manbang.ebatis.core.meta.FieldMeta;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.QueryClauses;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;

public abstract class AbstractClassMeta
implements ClassMeta {
    protected static final Map<Class<?>, ClassMeta> CLASS_METAS = new ConcurrentHashMap();
    private final Class<?> clazz;
    private final Map<Field, FieldMeta> fieldMetaMap;
    private final Map<Class<? extends Annotation>, List<FieldMeta>> queryClauses;
    private final List<FieldMeta> fieldMetas;
    private final List<MethodMeta> methodMetas;

    protected AbstractClassMeta(Class<?> clazz) {
        this.clazz = clazz;
        this.fieldMetas = this.getFieldMetas(clazz);
        this.fieldMetaMap = this.getFieldMetaMap(this.fieldMetas);
        this.queryClauses = this.getQueryClauses(this.fieldMetas);
        this.methodMetas = Collections.emptyList();
    }

    private List<FieldMeta> getFieldMetas(Class<?> clazz) {
        List metas = FieldUtils.getAllFieldsList(clazz).stream().filter(this::filterField).map(FieldMeta::of).collect(Collectors.toList());
        return Collections.unmodifiableList(metas);
    }

    private Map<Class<? extends Annotation>, List<FieldMeta>> getQueryClauses(List<FieldMeta> fieldMetas) {
        Map metas = fieldMetas.stream().collect(Collectors.groupingBy(FieldMeta::getQueryClauseAnnotationClass, Collectors.toList()));
        return Collections.unmodifiableMap(metas);
    }

    private Map<Field, FieldMeta> getFieldMetaMap(List<FieldMeta> fieldMetas) {
        Map<Field, FieldMeta> metas = fieldMetas.stream().collect(Collectors.toMap(AnnotatedMeta::getElement, meta -> meta));
        return Collections.unmodifiableMap(metas);
    }

    protected boolean filterField(Field field) {
        return QueryClauses.filterField(field);
    }

    @Override
    public List<MethodMeta> getMethodMetas() {
        return this.methodMetas;
    }

    @Override
    public Optional<MethodMeta> findMethodMeta(Method method) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodMeta getMethodMeta(Method method) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FieldMeta> getFieldMetas() {
        return this.fieldMetas;
    }

    @Override
    public Optional<FieldMeta> findFieldMeta(Field field) {
        return Optional.ofNullable(this.fieldMetaMap.get(field));
    }

    @Override
    public FieldMeta getFieldMeta(Field field) {
        return this.fieldMetaMap.computeIfAbsent(field, f -> {
            throw new FieldMetaNotFoundException(field.toString());
        });
    }

    @Override
    public Map<Class<? extends Annotation>, List<FieldMeta>> getQueryClauses() {
        return this.queryClauses;
    }

    @Override
    public Class<?> getElement() {
        return this.clazz;
    }
}

