/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.IntervalType;
import io.manbang.ebatis.core.domain.Range;
import io.manbang.ebatis.core.exception.ConditionNotSupportException;
import java.util.Calendar;
import java.util.Date;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;

class DefaultRange<T extends Comparable<T>>
implements Range<T> {
    private final T min;
    private final T max;
    private IntervalType leftIntervalType;
    private IntervalType rightIntervalType;
    private String name;

    public DefaultRange(T min, T max) {
        this.min = min;
        this.max = max;
        this.openLeft();
        this.openRight();
        if (min == null && max == null) {
            throw new ConditionNotSupportException("\u8303\u56f4\u7684\u4e0a\u4e0b\u9650\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    @Override
    public Range<T> setName(String name) {
        this.name = name;
        return this;
    }

    private Object getValue(Object value) {
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTimeInMillis();
        }
        return value;
    }

    @Override
    public Range<T> closeLeft() {
        this.leftIntervalType = IntervalType.CLOSED_INTERVAL;
        return this;
    }

    @Override
    public Range<T> openLeft() {
        this.leftIntervalType = IntervalType.OPEN_INTERVAL;
        return this;
    }

    @Override
    public Range<T> closeRight() {
        this.rightIntervalType = IntervalType.CLOSED_INTERVAL;
        return this;
    }

    @Override
    public Range<T> openRight() {
        this.rightIntervalType = IntervalType.OPEN_INTERVAL;
        return this;
    }

    @Override
    public QueryBuilder toBuilder() {
        Object left = this.getValue(this.min);
        Object right = this.getValue(this.max);
        RangeQueryBuilder builder = QueryBuilders.rangeQuery((String)this.name);
        if (left == null) {
            this.rightIntervalType.right(builder, right);
        } else if (right == null) {
            this.leftIntervalType.left(builder, left);
        } else {
            this.rightIntervalType.right(builder, right);
            this.leftIntervalType.left(builder, left);
        }
        return builder;
    }
}

