/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import io.manbang.ebatis.core.annotation.Http;
import io.manbang.ebatis.core.cluster.Cluster;
import io.manbang.ebatis.core.domain.ContextHolder;
import io.manbang.ebatis.core.domain.HttpConfig;
import io.manbang.ebatis.core.exception.RequestTypeNotSupportException;
import io.manbang.ebatis.core.executor.RequestExecutor;
import io.manbang.ebatis.core.mapper.MappingRouter;
import io.manbang.ebatis.core.meta.ClassMeta;
import io.manbang.ebatis.core.meta.FieldMeta;
import io.manbang.ebatis.core.meta.MapperInterface;
import io.manbang.ebatis.core.meta.MapperMethod;
import io.manbang.ebatis.core.meta.MetaUtils;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.ParameterMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.meta.ResultType;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMapperMethodMeta
implements MapperMethod {
    private static final Logger log = LoggerFactory.getLogger(DefaultMapperMethodMeta.class);
    private final Method method;
    private final List<ParameterMeta> parameterMetas;
    private final String[] indices;
    private final String[] types;
    private final BiFunction<MethodMeta, Object[], String[]> indicesSupplier;
    private final BiFunction<MethodMeta, Object[], String[]> typesSupplier;
    private final RequestType requestType;
    private final ResultType resultType;
    private final RequestExecutor requestExecutor;
    private final Annotation requestAnnotation;
    private final HttpConfig httpConfig;
    private final String[] includeFields;
    private final Class<?> returnType;
    private final Class<?> unwrappedReturnType;
    private ParameterMeta conditionParameter;
    private ParameterMeta pageableParameter;
    private ParameterMeta responseExtractorParameter;

    DefaultMapperMethodMeta(MapperInterface mapperInterface, Method method) {
        this.method = method;
        this.returnType = method.getReturnType();
        this.indices = mapperInterface.getIndices();
        this.types = mapperInterface.getTypes();
        Optional<MappingRouter> mappingRouter = Optional.ofNullable(mapperInterface.getMappingRouter());
        this.indicesSupplier = mappingRouter.map(r -> r::indices).orElse((methodMeta, objects) -> this.indices);
        this.typesSupplier = mappingRouter.map(r -> r::types).orElse((methodMeta, objects) -> this.types);
        this.requestType = this.getRequestType(method);
        this.resultType = this.getResultType(method);
        this.requestAnnotation = this.getAnnotation(this.requestType.getAnnotationClass());
        this.httpConfig = this.getHttpConfig(mapperInterface);
        this.requestExecutor = this.requestType.getRequestExecutor();
        this.parameterMetas = this.getParameterMetas(method);
        this.unwrappedReturnType = this.requestType.getEntityClass(this).orElse(null);
        this.includeFields = this.getIncludeFields(this.unwrappedReturnType);
        this.validate();
    }

    private void validate() {
        boolean validated = this.requestType.validate(this);
        if (!validated) {
            throw new UnsupportedOperationException(this.toString());
        }
    }

    private String[] getIncludeFields(Class<?> clazz) {
        return Optional.ofNullable(clazz).filter(c -> !MetaUtils.isBasic(c)).map(ClassMeta::of).map(c -> (String[])c.getFieldMetas().stream().map(FieldMeta::getName).toArray(String[]::new)).orElse(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private HttpConfig getHttpConfig(MapperInterface mapperInterface) {
        return this.findAnnotation(Http.class).map(this::createHttpConfig).orElse(mapperInterface.getHttpConfig());
    }

    private HttpConfig createHttpConfig(Http http) {
        return new HttpConfig().connectionRequestTimeout(http.connectionRequestTimeout()).connectTimeout(http.connectTimeout()).socketTimeout(http.socketTimeout());
    }

    private List<ParameterMeta> getParameterMetas(Method method) {
        ArrayList<ParameterMeta> metas = new ArrayList<ParameterMeta>(method.getParameterCount());
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            ParameterMeta meta = ParameterMeta.withIndex(this, parameters[i], i);
            metas.add(meta);
            if (meta.isPageable()) {
                this.pageableParameter = meta;
                continue;
            }
            if (meta.isResponseExtractor()) {
                this.responseExtractorParameter = meta;
                continue;
            }
            this.conditionParameter = meta;
        }
        return Collections.unmodifiableList(metas);
    }

    private ResultType getResultType(Method method) {
        return ResultType.valueOf(method);
    }

    private RequestType getRequestType(Method method) {
        return RequestType.valueOf(method).orElseThrow(() -> new RequestTypeNotSupportException(method.toString()));
    }

    @Override
    public Object invoke(Cluster cluster, Object[] args) {
        try {
            Object object = this.requestExecutor.execute(cluster, this, args);
            return object;
        }
        catch (Exception e) {
            log.error("\u63a5\u53e3\u6267\u884c\u5f02\u5e38: {}", (Object)this.method, (Object)e);
            throw e;
        }
        finally {
            ContextHolder.remove();
        }
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Override
    public String[] getIndices(MethodMeta meta, Object[] args) {
        return this.indicesSupplier.apply(meta, args);
    }

    @Override
    public String[] getTypes(MethodMeta meta, Object[] args) {
        return this.typesSupplier.apply(meta, args);
    }

    @Override
    public RequestType getRequestType() {
        return this.requestType;
    }

    @Override
    public ResultType getResultType() {
        return this.resultType;
    }

    @Override
    public <A extends Annotation> A getRequestAnnotation() {
        return (A)this.requestAnnotation;
    }

    @Override
    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    @Override
    public List<ParameterMeta> getParameterMetas() {
        return this.parameterMetas;
    }

    @Override
    public ParameterMeta getConditionParameter() {
        return this.conditionParameter;
    }

    @Override
    public Optional<ParameterMeta> findConditionParameter() {
        return Optional.ofNullable(this.conditionParameter);
    }

    @Override
    public Optional<ParameterMeta> getPageableParameter() {
        return Optional.ofNullable(this.pageableParameter);
    }

    @Override
    public ParameterMeta getResponseExtractorParameter() {
        return this.responseExtractorParameter;
    }

    @Override
    public String[] getIncludeFields() {
        return this.includeFields;
    }

    @Override
    public Optional<Class<?>> unwrappedReturnType() {
        return Optional.ofNullable(this.unwrappedReturnType);
    }

    @Override
    public ResponseExtractor<?> getResponseExtractor(Object[] args) {
        return this.responseExtractorParameter == null ? ResponseExtractorLoader.getResponseExtractor(this) : (ResponseExtractor)this.responseExtractorParameter.getValue(args);
    }

    @Override
    public Method getElement() {
        return this.method;
    }

    public String toString() {
        return this.method.toString();
    }
}

