/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.Aggregation;
import io.manbang.ebatis.core.domain.Script;
import io.manbang.ebatis.core.domain.SubAggregation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.PercentileRanksAggregationBuilder;

public class PercentileRanksAggregation
implements SubAggregation<PercentileRanksAggregation> {
    private final String name;
    private final double[] values;
    private String fieldName;
    private double compression = 100.0;
    private boolean keyed = true;
    private Object missing;
    private Script script;
    private final List<Aggregation> subAggregations = new ArrayList<Aggregation>();

    public PercentileRanksAggregation(String name, double[] values) {
        if (values == null) {
            throw new IllegalArgumentException("[values] must not be null: [" + name + "]");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("[values] must not be an empty array: [" + name + "]");
        }
        this.values = values;
        this.name = name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public PercentileRanksAggregation fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public PercentileRanksAggregation keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public PercentileRanksAggregation compression(double compression) {
        if (compression < 0.0) {
            throw new IllegalArgumentException("[compression] must be greater than or equal to 0. Found [" + compression + "] in [" + this.name + "]");
        }
        this.compression = compression;
        return this;
    }

    public PercentileRanksAggregation missing(Object missing) {
        this.missing = missing;
        return this;
    }

    public PercentileRanksAggregation script(Script script) {
        this.script = script;
        return this;
    }

    @Override
    public PercentileRanksAggregation subAgg(Aggregation ... aggs) {
        Collections.addAll(this.subAggregations, aggs);
        return this;
    }

    @Override
    public AggregationBuilder toAggBuilder() {
        PercentileRanksAggregationBuilder percentileRanks = AggregationBuilders.percentileRanks((String)this.name, (double[])this.values);
        percentileRanks.field(this.fieldName);
        percentileRanks.compression(this.compression);
        percentileRanks.keyed(this.keyed);
        if (!this.subAggregations.isEmpty()) {
            this.subAggregations.forEach(subAgg -> {
                PercentileRanksAggregationBuilder cfr_ignored_0 = (PercentileRanksAggregationBuilder)percentileRanks.subAggregation(subAgg.toAggBuilder());
            });
        }
        if (Objects.nonNull(this.missing)) {
            percentileRanks.missing(this.missing);
        }
        if (Objects.nonNull(this.script)) {
            percentileRanks.script(this.script.toEsScript());
        }
        return percentileRanks;
    }
}

