/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.config;

import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Env {
    private static final Logger log = LoggerFactory.getLogger(Env.class);
    public static final String DEBUG_ENABLED = "ebatis.debugEnabled";
    public static final String OFFLINE_ENABLED = "ebatis.offlineEnabled";
    public static final String CLUSTER_ROUTER_NAME = "ebatis.clusterRouter";
    public static boolean IS_DEBUG_ENABLED = false;
    public static boolean IS_OFFLINE_ENABLED = false;
    public static String DEFAULT_CLUSTER_ROUTER_NAME;

    private Env() {
    }

    public static boolean isDebugEnabled() {
        return IS_DEBUG_ENABLED;
    }

    public static boolean isOfflineEnabled() {
        return IS_OFFLINE_ENABLED;
    }

    public static String getClusterRouterName() {
        return DEFAULT_CLUSTER_ROUTER_NAME;
    }

    static {
        try (InputStream in = Env.class.getClassLoader().getResourceAsStream("ebatis.properties");){
            if (Objects.nonNull(in)) {
                Properties cfg = new Properties();
                cfg.load(in);
                IS_DEBUG_ENABLED = Boolean.parseBoolean(cfg.getProperty(DEBUG_ENABLED));
                IS_OFFLINE_ENABLED = Boolean.parseBoolean(cfg.getProperty(OFFLINE_ENABLED));
                DEFAULT_CLUSTER_ROUTER_NAME = cfg.getProperty(CLUSTER_ROUTER_NAME);
            } else {
                log.info("\u672a\u68c0\u6d4b\u5230ebatis.properties\u914d\u7f6e,\u9ed8\u8ba4\u4e0d\u5f00\u542f\u8c03\u8bd5\u6a21\u5f0f,\u79bb\u7ebf\u6a21\u5f0f.");
            }
        }
        catch (Exception e) {
            log.error("\u914d\u7f6e\u6587\u4ef6\u8f7d\u5165\u5931\u8d25", (Throwable)e);
        }
    }
}

