/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.cluster;

import io.manbang.ebatis.core.cluster.Cluster;
import io.manbang.ebatis.core.cluster.ClusterLoadBalancer;
import io.manbang.ebatis.core.cluster.ClusterRouter;
import io.manbang.ebatis.core.meta.MethodMeta;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterRouter
implements ClusterRouter {
    private static final Logger log = LoggerFactory.getLogger(AbstractClusterRouter.class);

    @Override
    public void close() throws IOException {
        for (Cluster cluster : this.getClusters()) {
            cluster.close();
        }
    }

    @Override
    public Cluster route(MethodMeta meta) {
        Cluster cluster = this.choose(meta);
        log.debug("\u9009\u5b9a\u96c6\u7fa4: {}", (Object)cluster.getName());
        return cluster;
    }

    private Cluster choose(MethodMeta meta) {
        return this.getLoadBalancer(meta).choose(this.getClusters());
    }

    protected abstract Cluster[] getClusters();

    protected abstract ClusterLoadBalancer getLoadBalancer(MethodMeta var1);
}

