/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import com.google.auto.service.AutoService;
import io.manbang.ebatis.core.annotation.SearchScroll;
import io.manbang.ebatis.core.domain.ScrollResponse;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.response.AbstractResponseExtractorProvider;
import io.manbang.ebatis.core.response.ClearScrollResponseExtractor;
import io.manbang.ebatis.core.response.DocumentMapper;
import io.manbang.ebatis.core.response.DocumentPageExtractor;
import io.manbang.ebatis.core.response.RawResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorProvider;
import io.manbang.ebatis.core.response.ScrollResponseExtractor;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchResponse;

@AutoService(value={ResponseExtractorProvider.class})
public class SearchScrollResponseExtractorProvider
extends AbstractResponseExtractorProvider {
    public SearchScrollResponseExtractorProvider() {
        super(RequestType.SEARCH_SCROLL);
    }

    @Override
    protected ResponseExtractor<?> getResponseExtractor(MethodMeta meta, GenericType genericType) {
        Class<?> entityClass = genericType.resolve();
        SearchScroll scroll = meta.getAnnotation(SearchScroll.class);
        if (scroll.clearScroll()) {
            if (Boolean.TYPE == entityClass || Boolean.class == entityClass) {
                return ClearScrollResponseExtractor.INSTANCE;
            }
            if (ClearScrollResponse.class == entityClass) {
                return RawResponseExtractor.INSTANCE;
            }
        }
        if (SearchResponse.class == entityClass) {
            return RawResponseExtractor.INSTANCE;
        }
        if (ScrollResponse.class == entityClass) {
            entityClass = genericType.resolveGeneric(0);
            return new ScrollResponseExtractor(new DocumentPageExtractor(DocumentMapper.of(entityClass)));
        }
        return null;
    }
}

