/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.request;

import io.manbang.ebatis.core.annotation.Update;
import io.manbang.ebatis.core.common.ActiveShardCountUtils;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.ParameterMeta;
import io.manbang.ebatis.core.provider.IdProvider;
import io.manbang.ebatis.core.provider.RoutingProvider;
import io.manbang.ebatis.core.provider.ScriptProvider;
import io.manbang.ebatis.core.request.AbstractRequestFactory;
import io.manbang.ebatis.core.request.RequestFactory;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.unit.TimeValue;

class UpdateRequestFactory
extends AbstractRequestFactory<Update, UpdateRequest> {
    static final UpdateRequestFactory INSTANCE = new UpdateRequestFactory();

    private UpdateRequestFactory() {
    }

    @Override
    protected void setAnnotationMeta(UpdateRequest request, Update update) {
        ((UpdateRequest)((UpdateRequest)request.fetchSource(update.fetchSource()).timeout(StringUtils.isBlank((CharSequence)update.timeout()) ? InstanceShardOperationRequest.DEFAULT_TIMEOUT : TimeValue.parseTimeValue((String)update.timeout(), (String)"\u66f4\u65b0\u8d85\u65f6\u65f6\u95f4"))).waitForActiveShards(ActiveShardCountUtils.getActiveShardCount(update.waitForActiveShards())).detectNoop(update.detectNoop()).docAsUpsert(update.docAsUpsert()).retryOnConflict(update.retryOnConflict()).setRefreshPolicy(update.refreshPolicy())).scriptedUpsert(update.scriptedUpsert());
        if (StringUtils.isNotBlank((CharSequence)update.id())) {
            Optional.ofNullable(request.doc()).ifPresent(doc -> doc.id(String.valueOf(doc.sourceAsMap().get(update.id()))));
        }
    }

    @Override
    protected UpdateRequest doCreate(MethodMeta meta, Object[] args) {
        UpdateRequest request = new UpdateRequest();
        request.index(meta.getIndex());
        this.setTypeIfNecessary(meta, arg_0 -> ((UpdateRequest)request).type(arg_0));
        ParameterMeta parameterMeta = meta.getConditionParameter();
        Object doc = parameterMeta.getValue(args);
        if (parameterMeta.isBasic()) {
            request.id(String.valueOf(doc));
        } else {
            if (doc instanceof IdProvider) {
                request.id(((IdProvider)doc).id());
            }
            if (doc instanceof ScriptProvider) {
                request.script(((ScriptProvider)doc).getScript().toEsScript());
            } else {
                IndexRequest indexRequest = RequestFactory.index().create(meta, args);
                request.doc(indexRequest);
            }
            if (doc instanceof RoutingProvider) {
                request.routing(((RoutingProvider)doc).routing());
            }
        }
        return request;
    }
}

