/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.annotation.Order;
import io.manbang.ebatis.core.domain.Aggregation;
import io.manbang.ebatis.core.domain.Script;
import io.manbang.ebatis.core.domain.SubAggregation;
import io.manbang.ebatis.core.domain.compatibility.CompatibleTermsAggregationBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class TermsAggregation
implements SubAggregation<TermsAggregation> {
    private String name;
    private String fieldName;
    private Script script;
    private List<Order> orders = new ArrayList<Order>();
    private int size = 10;
    private List<Aggregation> subAggregations = new ArrayList<Aggregation>();
    private Map<String, Object> metaData;
    private int shardSize = -1;
    private boolean showTermDocCountError = false;
    private long minDocCount = 1L;
    private long shardMinDocCount = 0L;

    TermsAggregation(String name) {
        this.name = name;
    }

    public Script getScript() {
        return this.script;
    }

    public TermsAggregation script(Script script) {
        this.script = script;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TermsAggregation name(String name) {
        this.name = name;
        return this;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public TermsAggregation fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public int getSize() {
        return this.size;
    }

    public TermsAggregation size(int size) {
        this.size = size;
        return this;
    }

    public List<Aggregation> getSubAggregations() {
        return this.subAggregations;
    }

    public int getShardSize() {
        return this.shardSize;
    }

    public TermsAggregation shardSize(int shardSize) {
        this.shardSize = shardSize;
        return this;
    }

    public boolean isShowTermDocCountError() {
        return this.showTermDocCountError;
    }

    public TermsAggregation showTermDocCountError(boolean showTermDocCountError) {
        this.showTermDocCountError = showTermDocCountError;
        return this;
    }

    public long getMinDocCount() {
        return this.minDocCount;
    }

    public TermsAggregation minDocCount(long minDocCount) {
        this.minDocCount = minDocCount;
        return this;
    }

    public long getShardMinDocCount() {
        return this.shardMinDocCount;
    }

    public TermsAggregation shardMinDocCount(long shardMinDocCount) {
        this.shardMinDocCount = shardMinDocCount;
        return this;
    }

    public TermsAggregation order(Order ... order) {
        Collections.addAll(this.orders, order);
        return this;
    }

    @Override
    public TermsAggregation subAgg(Aggregation ... aggs) {
        Collections.addAll(this.subAggregations, aggs);
        return this;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public TermsAggregation metaData(Map<String, Object> metaData) {
        this.metaData = metaData;
        return this;
    }

    @Override
    public AggregationBuilder toAggBuilder() {
        CompatibleTermsAggregationBuilder agg = new CompatibleTermsAggregationBuilder(this.name, null).size(this.size).showTermDocCountError(this.showTermDocCountError).minDocCount(this.minDocCount).shardMinDocCount(this.shardMinDocCount);
        if (Objects.nonNull(this.fieldName)) {
            agg.field(this.fieldName);
        }
        if (Objects.nonNull(this.script)) {
            agg.script(this.script.toEsScript());
        }
        if (this.shardSize != -1) {
            agg.shardSize(this.shardSize);
        }
        if (!this.orders.isEmpty()) {
            agg.order(this.orders.stream().map(Order::order).collect(Collectors.toList()));
        }
        if (!this.subAggregations.isEmpty()) {
            this.subAggregations.forEach(subAgg -> {
                TermsAggregationBuilder cfr_ignored_0 = (TermsAggregationBuilder)agg.subAggregation(subAgg.toAggBuilder());
            });
        }
        if (Objects.nonNull(this.metaData)) {
            agg.setMetaData(this.metaData);
        }
        return agg;
    }
}

