/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.builder.QueryBuilderFactory;
import io.manbang.ebatis.core.domain.Aggregation;
import io.manbang.ebatis.core.domain.SubAggregation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;

public class FiltersAggregation
implements SubAggregation<FiltersAggregation> {
    private String name;
    private List<Aggregation> subAggregations = new ArrayList<Aggregation>();
    private Map<String, Object> filters = new LinkedHashMap<String, Object>();

    public FiltersAggregation(String name) {
        this.name = name;
    }

    public FiltersAggregation filter(String key, Object condition) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(condition);
        this.filters.put(key, condition);
        return this;
    }

    @Override
    public FiltersAggregation subAgg(Aggregation ... aggs) {
        Collections.addAll(this.subAggregations, aggs);
        return this;
    }

    @Override
    public AggregationBuilder toAggBuilder() {
        ArrayList<FiltersAggregator.KeyedFilter> keyedFilters = new ArrayList<FiltersAggregator.KeyedFilter>();
        for (Map.Entry<String, Object> entry : this.filters.entrySet()) {
            keyedFilters.add(new FiltersAggregator.KeyedFilter(entry.getKey(), QueryBuilderFactory.bool().create(null, entry.getValue())));
        }
        FiltersAggregationBuilder filters = AggregationBuilders.filters((String)this.name, (FiltersAggregator.KeyedFilter[])keyedFilters.toArray(new FiltersAggregator.KeyedFilter[0]));
        if (!this.subAggregations.isEmpty()) {
            this.subAggregations.forEach(subAgg -> {
                FiltersAggregationBuilder cfr_ignored_0 = (FiltersAggregationBuilder)filters.subAggregation(subAgg.toAggBuilder());
            });
        }
        return filters;
    }
}

