/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.builder;

import io.manbang.ebatis.core.annotation.Must;
import io.manbang.ebatis.core.builder.AbstractQueryBuilderFactory;
import io.manbang.ebatis.core.builder.QueryBuilderFactory;
import io.manbang.ebatis.core.domain.Range;
import io.manbang.ebatis.core.meta.ConditionMeta;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;

class AutoQueryBuilderFactory
extends AbstractQueryBuilderFactory<QueryBuilder, Must> {
    static final AutoQueryBuilderFactory INSTANCE = new AutoQueryBuilderFactory();

    private AutoQueryBuilderFactory() {
    }

    @Override
    protected QueryBuilder doCreate(ConditionMeta meta, Object condition) {
        if (meta.isBasic()) {
            return QueryBuilderFactory.term().create(meta, condition);
        }
        if (meta.isRange()) {
            Range range = (Range)condition;
            range.setName(meta.getName());
            return range.toBuilder();
        }
        if (meta.isScript()) {
            io.manbang.ebatis.core.domain.Script script = (io.manbang.ebatis.core.domain.Script)condition;
            return QueryBuilders.scriptQuery((Script)script.toEsScript());
        }
        return QueryBuilderFactory.bool().create(meta, condition);
    }
}

