/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.annotation;

import java.util.Comparator;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;

public enum Order {
    COUNT_ASC(BucketOrder.count((boolean)true)),
    COUNT_DESC(BucketOrder.count((boolean)false)),
    TERM_ASC((BucketOrder)new InternalOrder(5, "_term", true, Order.comparingKeys())),
    TERM_DESC((BucketOrder)new InternalOrder(6, "_term", true, Order.comparingKeys()));

    private final BucketOrder order;

    private Order(BucketOrder order) {
        this.order = order;
    }

    public BucketOrder order() {
        return this.order;
    }

    private static Comparator<MultiBucketsAggregation.Bucket> comparingKeys() {
        return (b1, b2) -> {
            if (b1 instanceof KeyComparable) {
                return ((KeyComparable)b1).compareKey(b2);
            }
            throw new IllegalStateException("Unexpected order bucket class [" + b1.getClass() + "]");
        };
    }
}

