/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import com.google.auto.service.AutoService;
import io.manbang.ebatis.core.domain.Page;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MetaUtils;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.response.AbstractResponseExtractorProvider;
import io.manbang.ebatis.core.response.ArrayDocumentExtractor;
import io.manbang.ebatis.core.response.DocumentExtractor;
import io.manbang.ebatis.core.response.DocumentMapper;
import io.manbang.ebatis.core.response.DocumentPageExtractor;
import io.manbang.ebatis.core.response.RawResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorProvider;
import io.manbang.ebatis.core.response.SingleDocumentExtractor;
import io.manbang.ebatis.core.response.TotalHitsSearchResponseExtractor;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.action.search.SearchResponse;

@AutoService(value={ResponseExtractorProvider.class})
public class SearchResponseExtractorProvider
extends AbstractResponseExtractorProvider {
    public SearchResponseExtractorProvider() {
        super(RequestType.SEARCH);
    }

    protected SearchResponseExtractorProvider(RequestType requestType) {
        super(requestType);
    }

    @Override
    protected ResponseExtractor<?> getResponseExtractor(MethodMeta meta, GenericType genericType) {
        Class<?> resultClass = genericType.resolve();
        if (SearchResponse.class == resultClass) {
            return RawResponseExtractor.INSTANCE;
        }
        if (Long.class == resultClass || Long.TYPE == resultClass) {
            return TotalHitsSearchResponseExtractor.INSTANCE;
        }
        if (Boolean.class == resultClass || Boolean.TYPE == resultClass) {
            return response -> !NumberUtils.LONG_ZERO.equals(TotalHitsSearchResponseExtractor.INSTANCE.doExtractData((SearchResponse)response));
        }
        if (Page.class.isAssignableFrom(resultClass)) {
            return new DocumentPageExtractor(DocumentMapper.of(genericType.resolveGeneric(0)));
        }
        if (List.class.isAssignableFrom(resultClass)) {
            return new DocumentExtractor(DocumentMapper.of(genericType.resolveGeneric(0)), Integer.MAX_VALUE);
        }
        if (resultClass.isArray()) {
            return new ArrayDocumentExtractor(DocumentMapper.of(genericType.resolveGeneric(0)), Integer.MAX_VALUE);
        }
        if (!MetaUtils.isBasic(resultClass)) {
            return new SingleDocumentExtractor(DocumentMapper.of(resultClass));
        }
        throw new UnsupportedOperationException();
    }
}

