/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import io.manbang.ebatis.core.domain.ContextHolder;
import io.manbang.ebatis.core.domain.Page;
import io.manbang.ebatis.core.domain.Pageable;
import io.manbang.ebatis.core.response.DocumentPageExtractor;
import io.manbang.ebatis.core.response.MultiSearchResponseExtractor;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.action.search.MultiSearchResponse;

public class PageMultiSearchResponseExtractor<T>
implements MultiSearchResponseExtractor<List<Page<T>>> {
    private final DocumentPageExtractor<T> extractor;

    public PageMultiSearchResponseExtractor(DocumentPageExtractor<T> extractor) {
        this.extractor = extractor;
    }

    @Override
    public List<Page<T>> doExtractData(MultiSearchResponse response) {
        LinkedList<Page<T>> pages = new LinkedList<Page<T>>();
        MultiSearchResponse.Item[] responses = response.getResponses();
        Pageable[] pageables = ContextHolder.getContext().getPageables().orElse(new Pageable[response.getResponses().length]);
        for (int i = 0; i < responses.length; ++i) {
            MultiSearchResponse.Item item = responses[i];
            ContextHolder.setPageable(pageables[i]);
            pages.add(this.extractor.doExtractData(item.getResponse()));
        }
        return pages;
    }
}

