/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import io.manbang.ebatis.core.response.DocumentMapper;
import io.manbang.ebatis.core.response.SearchResponseExtractor;
import java.lang.reflect.Array;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;

public class ArrayDocumentExtractor<T>
implements SearchResponseExtractor<T[]> {
    private final DocumentMapper<T> documentMapper;
    private final int expectedCount;

    public ArrayDocumentExtractor(DocumentMapper<T> documentMapper, int expectedCount) {
        this.documentMapper = documentMapper;
        this.expectedCount = expectedCount;
    }

    @Override
    public T[] doExtractData(SearchResponse response) {
        SearchHit[] hits = response.getHits().getHits();
        int hitCount = hits.length;
        int count = Math.min(this.expectedCount, hitCount);
        Object[] result = (Object[])Array.newInstance(this.documentMapper.getEntityClass(), count);
        for (int i = 0; i < count; ++i) {
            result[i] = this.documentMapper.mapRow(hits[i], i + 1);
        }
        return result;
    }
}

