/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import io.manbang.ebatis.core.common.AnnotationUtils;
import io.manbang.ebatis.core.domain.Pageable;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.AbstractConditionMeta;
import io.manbang.ebatis.core.meta.ClassMeta;
import io.manbang.ebatis.core.meta.FieldMeta;
import io.manbang.ebatis.core.meta.MetaUtils;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.ParameterMeta;
import io.manbang.ebatis.core.response.ResponseExtractor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

class DefaultParameterMeta
extends AbstractConditionMeta<Parameter>
implements ParameterMeta {
    private final Parameter parameter;
    private final int index;
    private final boolean pageable;
    private final boolean responseExtractor;
    private final boolean basic;
    private final boolean basicArrayOrCollection;
    private final String name;
    private final Annotation requestAnnotation;
    private final Map<Class<? extends Annotation>, Optional<? extends Annotation>> metas = new ConcurrentHashMap<Class<? extends Annotation>, Optional<? extends Annotation>>();

    DefaultParameterMeta(MethodMeta methodMeta, Parameter parameter, int index) {
        super(parameter, parameter.getType(), parameter.getParameterizedType());
        this.parameter = parameter;
        this.index = index;
        this.name = parameter.getName();
        Class<?> type = this.getActualType(parameter);
        this.basic = MetaUtils.isBasic(type);
        this.pageable = Pageable.class == type;
        this.responseExtractor = ResponseExtractor.class == type;
        this.basicArrayOrCollection = this.isArrayOrCollection() && this.basic;
        this.requestAnnotation = methodMeta.getRequestAnnotation();
    }

    private Class<?> getActualType(Parameter parameter) {
        Class<?> type = this.isArray() ? this.getType().getComponentType() : (this.isCollection() ? GenericType.forMethod((Method)parameter.getDeclaringExecutable()).parameterType(this.index).resolveGeneric(0) : this.getType());
        return type;
    }

    @Override
    protected String getName(Parameter parameter) {
        String n = super.getName(parameter);
        return StringUtils.isBlank((CharSequence)n) ? parameter.getName() : n;
    }

    @Override
    public Parameter getElement() {
        return this.parameter;
    }

    @Override
    public Map<Class<? extends Annotation>, List<FieldMeta>> getQueryClauses(Object instance) {
        return ClassMeta.parameter(this.parameter, instance == null ? null : instance.getClass()).getQueryClauses();
    }

    @Override
    public boolean isPageable() {
        return this.pageable;
    }

    @Override
    public boolean isResponseExtractor() {
        return this.responseExtractor;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isBasic() {
        return this.basic;
    }

    @Override
    public boolean isBasicArrayOrCollection() {
        return this.basicArrayOrCollection;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <A extends Annotation> Optional<A> findAttributeAnnotation(Class<A> annotationClass) {
        return this.metas.computeIfAbsent(annotationClass, clazz -> AnnotationUtils.findAttributeAnnotation(this.requestAnnotation, clazz));
    }

    @Override
    public Object getValue(Object[] args) {
        return args[this.index];
    }

    public String toString() {
        return "DefaultParameterMeta(parameter=" + this.parameter + ")";
    }
}

