/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.executor;

import io.manbang.ebatis.core.cluster.Cluster;
import io.manbang.ebatis.core.executor.RequestExecutor;
import io.manbang.ebatis.core.interceptor.DefaultRequestInfo;
import io.manbang.ebatis.core.interceptor.Interceptor;
import io.manbang.ebatis.core.interceptor.InterceptorFactory;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.request.RequestFactory;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.session.ClusterSession;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestExecutor<R extends ActionRequest>
implements RequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestExecutor.class);
    private final Interceptor interceptor = InterceptorFactory.interceptors();
    private final RequestFactory<R> requestFactory = this.getRequestFactory();

    protected AbstractRequestExecutor() {
    }

    @Override
    public Object execute(Cluster cluster, MethodMeta meta, Object[] args) {
        this.interceptor.preRequest(args, cluster, meta);
        R request = this.requestFactory.create(meta, args);
        this.interceptor.postRequest(new DefaultRequestInfo<R>(request, args));
        ResponseExtractor<?> extractor = meta.getResponseExtractor(args);
        ClusterSession session = ClusterSession.of(cluster);
        CompletableFuture<?> future = this.getRequestAction(session).call(request, extractor);
        return meta.getResultType().adaptResult(future);
    }

    protected abstract RequestAction<R> getRequestAction(ClusterSession var1);

    protected abstract RequestFactory<R> getRequestFactory();

    @FunctionalInterface
    protected static interface RequestAction<R extends ActionRequest> {
        public CompletableFuture<?> call(R var1, ResponseExtractor<?> var2);
    }
}

