/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.FieldValueFactorScoreFunction;
import io.manbang.ebatis.core.domain.RandomScoreFunction;
import io.manbang.ebatis.core.domain.Script;
import io.manbang.ebatis.core.domain.ScriptScoreFunction;
import io.manbang.ebatis.core.domain.WeightScoreFunction;
import org.elasticsearch.common.lucene.search.function.FieldValueFactorFunction;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;

public interface ScoreFunction {
    public static ScoreFunction inlineScript(String source, Object params) {
        return new ScriptScoreFunction(Script.inline(source, params));
    }

    public static ScoreFunction storedScript(String id, Object params) {
        return new ScriptScoreFunction(Script.stored(id, params));
    }

    public static ScoreFunction randomScore() {
        return RandomScoreFunction.INSTANCE;
    }

    public static ScoreFunction fieldValueFactor(String fieldName, float factor, double missing, FieldValueFactorFunction.Modifier modifier) {
        return new FieldValueFactorScoreFunction(fieldName).factor(factor).missing(missing).modifier(modifier);
    }

    public static ScoreFunction weightScore(float weight, Object weightCondition) {
        return new WeightScoreFunction(weight, weightCondition);
    }

    public FunctionScoreQueryBuilder.FilterFunctionBuilder toFunctionBuilder();
}

