/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.builder;

import io.manbang.ebatis.core.annotation.FunctionScore;
import io.manbang.ebatis.core.builder.AbstractQueryBuilderFactory;
import io.manbang.ebatis.core.builder.QueryBuilderFactory;
import io.manbang.ebatis.core.domain.ScoreFunction;
import io.manbang.ebatis.core.domain.ScoreFunctionMode;
import io.manbang.ebatis.core.exception.ConditionNotSupportException;
import io.manbang.ebatis.core.meta.ConditionMeta;
import io.manbang.ebatis.core.provider.ScoreFunctionProvider;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FunctionScoreQueryBuilderFactory
extends AbstractQueryBuilderFactory<QueryBuilder, FunctionScore> {
    private static final Logger log = LoggerFactory.getLogger(FunctionScoreQueryBuilderFactory.class);
    static final FunctionScoreQueryBuilderFactory INSTANCE = new FunctionScoreQueryBuilderFactory();

    private FunctionScoreQueryBuilderFactory() {
    }

    @Override
    protected void setAnnotationMeta(QueryBuilder builder, FunctionScore functionScore) {
    }

    @Override
    protected QueryBuilder doCreate(ConditionMeta meta, Object condition) {
        if (!(condition instanceof ScoreFunctionProvider)) {
            throw new ConditionNotSupportException("\u6761\u4ef6\u5fc5\u987b\u5b9e\u73b0: ScoreFunctionProvider");
        }
        QueryBuilder queryBuilder = QueryBuilderFactory.bool().create(meta, condition);
        ScoreFunctionProvider provider = (ScoreFunctionProvider)condition;
        Object[] functions = provider.getFunctions();
        if (ArrayUtils.isEmpty((Object[])functions)) {
            return queryBuilder;
        }
        FunctionScoreQueryBuilder.FilterFunctionBuilder[] functionBuilders = (FunctionScoreQueryBuilder.FilterFunctionBuilder[])Stream.of(functions).map(ScoreFunction::toFunctionBuilder).toArray(FunctionScoreQueryBuilder.FilterFunctionBuilder[]::new);
        FunctionScoreQueryBuilder functionScoreQueryBuilder = new FunctionScoreQueryBuilder(queryBuilder, functionBuilders);
        ScoreFunctionMode scoreFunctionMode = provider.getFunctionMode();
        Optional.ofNullable(scoreFunctionMode).ifPresent(sfm -> functionScoreQueryBuilder.maxBoost(sfm.getMaxBoost()).setMinScore(sfm.getMinScore()).scoreMode(sfm.getScoreMode()).boostMode(sfm.getBoostMode()));
        return functionScoreQueryBuilder;
    }
}

