/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.system.mapper;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import io.lsn.spring.system.mapper.SystemMapperRegistry;
import io.lsn.spring.system.mapper.domain.SystemMapperChangeEvent;
import io.lsn.spring.system.mapper.domain.SystemMapperDaoInterface;
import io.lsn.spring.system.mapper.domain.SystemMapperItem;
import io.lsn.spring.system.mapper.exception.SystemMapperException;
import io.lsn.spring.utilities.json.mapper.JsonMapper;
import java.util.ArrayList;
import java.util.List;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemMapperService {
    private final Logger logger = LoggerFactory.getLogger(SystemMapperService.class);
    private SystemMapperDaoInterface dao;
    private RTopic systemMapperChangeEventRTopic;
    private List<SystemMapperItem> systemMappingList;

    @Autowired
    public SystemMapperService(SystemMapperDaoInterface dao, RedissonClient redissonClient) {
        this.dao = dao;
        if (redissonClient != null) {
            this.systemMapperChangeEventRTopic = redissonClient.getTopic("io.lsn.lib.system.mapper");
            this.initListeners();
        }
        this.load();
        SystemMapperRegistry.setService(this);
    }

    private void initListeners() {
        this.systemMapperChangeEventRTopic.addListener(SystemMapperChangeEvent.class, (s, systemMapperChangeEvent) -> {
            this.logger.info("reload system mapping definition");
            this.load();
        });
    }

    private void load() {
        String mappingsJson = this.dao.getList();
        this.systemMappingList = new ArrayList<SystemMapperItem>();
        try {
            this.systemMappingList = JsonMapper.getInstance().mapListFromJsonSnakeCase(mappingsJson, SystemMapperItem[].class);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<SystemMapperItem> getSystemMappingList() {
        return this.systemMappingList;
    }

    public SystemMapperItem getSystemMapping(String sourceSystem, String sourceDictionary, String sourceCode, String destinationSystem) throws SystemMapperException {
        SystemMapperItem result = this.getSystemMappingList().stream().filter(e -> e.getSourceSystem().equalsIgnoreCase(sourceSystem) && e.getSourceDictionary().equalsIgnoreCase(sourceDictionary) && e.getSourceCode().equalsIgnoreCase(sourceCode) && e.getDestinationSystem().equalsIgnoreCase(destinationSystem)).findFirst().orElse(null);
        if (result == null) {
            String sourceIndex = sourceSystem + "." + sourceDictionary + "." + sourceCode;
            String msg = "Cant find proper mapping for index: ".concat(sourceIndex).concat(" to system ").concat(destinationSystem);
            throw new SystemMapperException(msg);
        }
        return result;
    }

    public String getSystemMappingCodeSafe(String sourceSystem, String sourceDictionary, String sourceCode, String destinationSystem) {
        try {
            return this.getSystemMapping(sourceSystem, sourceDictionary, sourceCode, destinationSystem).getDestinationCode();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void notifyMappingChange() {
        if (this.systemMapperChangeEventRTopic != null) {
            this.systemMapperChangeEventRTopic.publish((Object)new SystemMapperChangeEvent());
        }
    }
}

