package io.lsn.spring.result.cache.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.lsn.spring.result.cache.configuration.domain.ResultCacheProperties;
import io.lsn.spring.utilities.cache.RedissonConfigurationHelper;
import io.lsn.spring.utilities.json.mapper.JsonMapper;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties({ResultCacheProperties.class, RedisProperties.class})
public class ResultCacheConfiguration {

    @Bean(name = "io.lsn.spring.result.cache.redisson")
    @Autowired
    public RedissonClient redisConnectionFactoryResultCache(ObjectMapper objectMapper, RedisProperties redisProperties, ResultCacheProperties properties) {
        Config config = RedissonConfigurationHelper.getDefaultConfiguration(redisProperties, properties.getCache().getDatabase())
                .setCodec(new JsonJacksonCodec(objectMapper));
        return Redisson.create(config);
    }

    @Bean(name = "io.lsn.spring.result.cache.object.mapper")
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper()
                .configure(MapperFeature.DEFAULT_VIEW_INCLUSION, true)
                .configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false)
                .configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true)
                .findAndRegisterModules()
                .registerModule(new JavaTimeModule());

        JsonMapper.getInstance().getObjectMapper().configure(MapperFeature.DEFAULT_VIEW_INCLUSION, true);
        JsonMapper.getInstance().getObjectMapper().findAndRegisterModules();
        JsonMapper.getInstance().getObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        JsonMapper.getInstance().getObjectMapper().configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);

        JsonMapper.getInstance().getObjectMapperSnakeCase().configure(MapperFeature.DEFAULT_VIEW_INCLUSION, true);
        JsonMapper.getInstance().getObjectMapperSnakeCase().findAndRegisterModules();
        JsonMapper.getInstance().getObjectMapperSnakeCase().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        JsonMapper.getInstance().getObjectMapperSnakeCase().configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);

        return mapper;
    }

}
