package io.leopard.web.avgtime;

import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunInfoServiceImpl implements RunInfoService {

	// protected final Log logger = Log4jFactory.getTimeAvgLogger(this.getClass());
	protected final Log logger = LogFactory.getLog("AVGTIME." + this.getClass().getName());

	private RunInfoDao runInfoDao = new RunInfoDaoMemoryImpl();

	public RunInfoServiceImpl() {
		// System.out.println("new instance RunInfoServiceImpl");
	}

	@Override
	public boolean add(String blockName, long runTime) {
		Type[] types = Type.values();
		for (Type type : types) {// 遍历所有类型
			RunInfo runInfo = new RunInfo();
			runInfo.setBlockName(blockName);
			runInfo.setType(type.getKey());
			runInfo.setRunTime(runTime);
			runInfoDao.add(runInfo);
		}
		return true;
	}

	@Override
	public List<RunInfo> listAll() {
		return this.runInfoDao.listAll();
	}

	@Override
	public boolean remove(String blockName, int type) {
		return this.runInfoDao.remove(blockName, type);
	}

	@Override
	public void startTimer() {
		// logger.debug("startTimer:" + Thread.currentThread().getName());
		Timer timer = new Timer();
		timer.schedule(new TimerTask() {
			@Override
			public void run() {
				try {
					writeLog();
				}
				catch (Exception e) {
					e.printStackTrace();
				}
			}
		}, 0, 1000);
	}

	@Override
	public void writeLog() {
		Date currentDate = new Date();
		if (!RunInfoUtil.isCriticalPoint(1, currentDate)) {
			// 还没有到临街秒数
			return;
		}
		List<RunInfo> runInfoList = this.listAll();
		for (RunInfo runInfo : runInfoList) {
			int minute = RunInfoUtil.getMinute(runInfo);
			String message = RunInfoUtil.runInfo(runInfo, minute);// 获取日志输出信息
			if (RunInfoUtil.isCriticalPoint(runInfo.getType(), currentDate)) {// 统计已经超过所属“类型”时间
				this.remove(runInfo.getBlockName(), runInfo.getType());
			}
			logger.debug(message);
			// System.out.println(message);
		}

	}
}
