package io.leopard.web.avgtime;

import io.leopard.web.servlet.RegisterHandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

/**
 * 页面耗时日志.
 * 
 * @author 阿海
 * 
 */
@Component
public class AvgTimeInterceptor extends RegisterHandlerInterceptor {

	private ThreadLocal<AvgTime> data = new ThreadLocal<AvgTime>();

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
		String requestUri = request.getRequestURI();// 这里不需要去掉contextPath

		// String queryString = request.getQueryString();
		// String url;
		// if (queryString != null && queryString.length() > 0) {
		// url = requestUri + "?" + queryString;
		// }
		// else {
		// url = requestUri;
		// }
		AvgTime avgTime = AvgTime.start(requestUri);// 平均耗时统计
		data.set(avgTime);
		return true;
	}

	@Override
	public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
		data.get().end();
	}

}
