/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.json;

import io.leopard.core.MethodTime;
import io.leopard.core.MethodTimeImpl;
import io.leopard.json.JsonException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.type.TypeFactory;

public class Json {
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectMapper mapperIgnoreUnknownField = new ObjectMapper();
    private static ObjectWriter writer = new ObjectMapper().writer().withDefaultPrettyPrinter();
    private static final Log logger = LogFactory.getLog(Json.class);
    private static MethodTime METHOD_TIME = MethodTimeImpl.getInstance();

    public static String toFormatJson(Object obj) {
        if (obj == null) {
            return null;
        }
        long startTime = System.nanoTime();
        try {
            String string = writer.writeValueAsString(obj);
            return string;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
            throw new JsonException(e.getMessage(), e);
        }
        finally {
            MethodTimeImpl.getInstance().addByStartTime("io.leopard.json.Json.toFormatJson", startTime);
        }
    }

    public static String toJson(Object obj) {
        long startTime = System.nanoTime();
        try {
            String json = obj == null ? null : mapper.writeValueAsString(obj);
            String string = json;
            return string;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
            throw new JsonException(e.getMessage(), e);
        }
        finally {
            METHOD_TIME.addByStartTime("io.leopard.json.Json.toJson", startTime);
        }
    }

    public static <T> List<T> toListObject(String content, Class<T> valueType) {
        if (content == null || content.length() == 0) {
            return null;
        }
        long startTime = System.nanoTime();
        try {
            List list = (List)mapper.readValue(content, TypeFactory.collectionType(List.class, valueType));
            return list;
        }
        catch (Exception e) {
            logger.warn((Object)("message:" + e.getMessage() + " content:" + content));
            throw new JsonException(e.getMessage(), e);
        }
        finally {
            METHOD_TIME.addByStartTime("io.leopard.json.Json.toListObject", startTime);
        }
    }

    public static <T> List<T> toObject(List<String> jsonList, Class<T> valueType) {
        return Json.toObject(jsonList, valueType, false);
    }

    public static <T> List<T> toObject(List<String> jsonList, Class<T> valueType, boolean ignoreUnknownField) {
        if (jsonList == null || jsonList.isEmpty()) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (String json : jsonList) {
            list.add(Json.toObject(json, valueType, ignoreUnknownField));
        }
        return list;
    }

    public static Map<String, Object> toMap(String content) {
        return Json.toObject(content, Map.class);
    }

    public static Set<Object> toSet(String content) {
        return Json.toObject(content, Set.class);
    }

    public static <T> Map<String, T> toMap(String json, Class<T> clazz) {
        return Json.toObject(json, Map.class);
    }

    public static <T> Set<T> toSet(String json, Class<T> clazz) {
        return Json.toObject(json, Set.class);
    }

    public static Map<String, Object> toNotNullMap(String json) {
        LinkedHashMap map = Json.toObject(json, Map.class);
        if (map == null) {
            map = new LinkedHashMap();
        }
        return map;
    }

    public static <T> Map<String, T> toNotNullMap(String json, Class<T> clazz) {
        LinkedHashMap map = Json.toObject(json, Map.class);
        if (map == null) {
            map = new LinkedHashMap();
        }
        return map;
    }

    public static <T> Set<T> toNotNullSet(String json, Class<T> clazz) {
        LinkedHashSet set = Json.toObject(json, Set.class);
        if (set == null) {
            set = new LinkedHashSet();
        }
        return set;
    }

    @Deprecated
    public static <T> T convert(Object obj, Class<T> clazz) {
        String json = Json.toJson(obj);
        return Json.toObject(json, clazz);
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        return Json.toObject(json, clazz, false);
    }

    public static <T> T toObject(String json, Class<T> clazz, boolean ignoreUnknownField) {
        if (json == null || json.length() == 0) {
            return null;
        }
        long startTime = System.nanoTime();
        try {
            if (ignoreUnknownField) {
                Object object = mapperIgnoreUnknownField.readValue(json, clazz);
                return (T)object;
            }
            Object object = mapper.readValue(json, clazz);
            return (T)object;
        }
        catch (Exception e) {
            logger.warn((Object)("message:" + e.getMessage() + " json:" + json));
            throw new JsonException(e.getMessage(), e);
        }
        finally {
            METHOD_TIME.addByStartTime("io.leopard.json.Json.toObject", startTime);
        }
    }

    public static void print(Object obj) {
        String json = Json.toJson(obj);
        System.out.println("json:" + json);
    }

    public static void print(Object obj, String name) {
        String json = Json.toJson(obj);
        System.out.println("json info " + name + "::" + json);
    }

    public static void printFormat(Object obj, String name) {
        String json = Json.toFormatJson(obj);
        System.out.println("json info " + name + "::" + json);
    }

    public static void printMap(Map map, String name) {
        if (map == null) {
            System.out.println("json info " + name + "::null");
            return;
        }
        if (map.size() == 0) {
            System.out.println("json info " + name + "::");
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            System.out.println(name + " key:" + key + " json:" + Json.toJson(value));
        }
    }

    public static void printList(List list, String name) {
        if (list == null) {
            System.out.println("json info " + name + "::null");
            return;
        }
        if (list.size() == 0) {
            System.out.println("json info " + name + "::");
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            System.out.println("json info(" + i + ") " + name + "::" + Json.toJson(element));
        }
    }

    protected static String toJson(ObjectWriter writer, Object obj, String fullMethodName) {
        if (obj == null) {
            return null;
        }
        long startTime = System.nanoTime();
        try {
            String string = writer.writeValueAsString(obj);
            return string;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
            throw new JsonException(e.getMessage(), e);
        }
        finally {
            MethodTimeImpl.getInstance().addByStartTime(fullMethodName, startTime);
        }
    }

    static {
        mapperIgnoreUnknownField.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

