/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.boot.servlet.util;

import io.leopard.boot.servlet.util.CookieUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtil {
    private static final Log logger = LogFactory.getLog(RequestUtil.class);
    private static final Pattern IS_VALID_IP_PATTERN = Pattern.compile("^[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}$");

    public static String getProxyIp(HttpServletRequest request) {
        String proxyIp = request.getHeader("X-Real-IP");
        if (proxyIp == null) {
            proxyIp = request.getHeader("RealIP");
        }
        if (proxyIp == null) {
            proxyIp = request.getRemoteAddr();
        }
        return proxyIp;
    }

    public static String getRequestContextUri(HttpServletRequest request) {
        String requestURI;
        String contextPath = request.getContextPath();
        if ("/".equals(contextPath)) {
            requestURI = request.getRequestURI();
        } else {
            String uri = request.getRequestURI();
            requestURI = uri.substring(contextPath.length());
        }
        if (requestURI.indexOf("//") != -1) {
            requestURI = requestURI.replaceAll("/+", "/");
        }
        return requestURI;
    }

    public static HttpServletRequest getCurrentRequest() {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attr == null) {
            return null;
        }
        return attr.getRequest();
    }

    public static boolean isHttps(HttpServletRequest request) {
        String protocol = request.getProtocol();
        if ("https".equalsIgnoreCase(protocol)) {
            return true;
        }
        boolean isHttps = "true".equals(request.getHeader("isHttps"));
        return isHttps;
    }

    public static String getSchemeAndServerName(HttpServletRequest request) {
        String scheme;
        boolean isHttps = RequestUtil.isHttps(request);
        StringBuilder sb = new StringBuilder(48);
        int port = request.getServerPort();
        if (isHttps) {
            scheme = "https";
            if (port == 80) {
                port = 443;
            }
        } else {
            scheme = "http";
        }
        sb.append(scheme);
        sb.append("://");
        sb.append(request.getServerName());
        if (!(port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
            sb.append(':');
            sb.append(port);
        }
        return sb.toString();
    }

    public static String getDomain(HttpServletRequest request) {
        String domain = "http://" + request.getServerName();
        return domain;
    }

    public static String getUserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        return userAgent;
    }

    public static int getPageid(Integer pageid) {
        if (pageid == null || pageid <= 0) {
            return 1;
        }
        return pageid;
    }

    public static void printHeaders(HttpServletRequest request) {
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getHeader(name);
            logger.info((Object)("header " + name + ":" + value));
        }
    }

    public static boolean isValidIp(String ip) {
        if (ip == null || ip.length() == 0) {
            return false;
        }
        Matcher m = IS_VALID_IP_PATTERN.matcher(ip);
        return m.find();
    }

    public static void printAttributes(HttpServletRequest request) {
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = request.getAttribute(name);
            logger.info((Object)("attribute " + name + ":" + value));
        }
    }

    public static String getReferer(HttpServletRequest request) {
        return request.getHeader("referer");
    }

    public static String getString(HttpServletRequest request, String parameterName, String defaultValue) {
        String value = request.getParameter(parameterName);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public static String getRequestURL(HttpServletRequest request) {
        String scheme;
        boolean isHttps = "true".equals(request.getHeader("isHttps"));
        StringBuilder sb = new StringBuilder(48);
        int port = request.getServerPort();
        if (isHttps) {
            scheme = "https";
            if (port == 80) {
                port = 443;
            }
        } else {
            scheme = "http";
        }
        sb.append(scheme);
        sb.append("://");
        sb.append(request.getServerName());
        if (!(port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
            sb.append(':');
            sb.append(port);
        }
        sb.append(request.getRequestURI());
        return sb.toString();
    }

    public static String getCookieUsername(HttpServletRequest request) {
        String username = CookieUtil.getCookie("username", request);
        try {
            username = URLDecoder.decode(username, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return username;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("X-Requested-With");
        return "XMLHttpRequest".equals(requestedWith);
    }

    public static String getFirstFolder(String path) {
        int index = path.indexOf("/", 1);
        if (index == -1) {
            return null;
        }
        return path.substring(0, index + 1);
    }
}

