/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.boot.data.queue;

import io.leopard.boot.data.queue.QueueRedisImpl;
import io.leopard.boot.spring.util.EnvironmentUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class QueueRegistrar
implements EnvironmentAware,
ImportBeanDefinitionRegistrar {
    private List<String> nameList = new ArrayList<String>();
    private ConfigurableEnvironment env;

    public void setEnvironment(Environment environment) {
        this.env = (ConfigurableEnvironment)environment;
        Set nameSet = EnvironmentUtil.findPropertyeNameSet((ConfigurableEnvironment)this.env, (String)"^.+\\.queue\\.host$");
        for (String name : nameSet) {
            String prefix = name.replaceFirst("\\.queue\\.host$", "");
            this.nameList.add(prefix);
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        for (String name : this.nameList) {
            this.registerQueueBean(name, registry);
        }
    }

    protected void registerQueueBean(String name, BeanDefinitionRegistry registry) {
        String host = this.env.getProperty(name + ".queue.host");
        String port = this.env.getProperty(name + ".queue.port");
        String password = this.env.getProperty(name + ".queue.password");
        String maxActive = this.env.getProperty(name + ".queue.maxActive");
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(QueueRedisImpl.class);
        beanDefinition.setSynthetic(true);
        beanDefinition.setInitMethodName("init");
        beanDefinition.setDestroyMethodName("destroy");
        MutablePropertyValues mpv = beanDefinition.getPropertyValues();
        mpv.addPropertyValue("server", (Object)(host + ":" + port));
        mpv.addPropertyValue("password", (Object)password);
        if (!StringUtils.isEmpty((Object)maxActive)) {
            mpv.addPropertyValue("maxActive", (Object)Integer.parseInt(maxActive));
        }
        String beanNaname = "app".equals(name) || "queue".equals(name) ? "queue" : name + "Queue";
        registry.registerBeanDefinition(beanNaname, (BeanDefinition)beanDefinition);
    }
}

