/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.boot.excel;

import io.leopard.boot.excel.Row;
import jxl.CellView;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class Sheet {
    private WritableSheet sheet;
    private int currentRow;

    public Sheet(WritableWorkbook workbook, String sheetName) {
        this.sheet = workbook.createSheet(sheetName, 0);
        this.currentRow = 1;
    }

    public void addColumnName(String ... columnNames) throws WriteException {
        int columnCount = this.sheet.getColumns();
        for (int i = 0; i < columnNames.length; ++i) {
            WritableFont wf = new WritableFont(WritableFont.TIMES, 11, WritableFont.BOLD);
            WritableCellFormat cf = new WritableCellFormat(wf);
            Label label = new Label(i + columnCount, 0, columnNames[i], (CellFormat)cf);
            this.sheet.addCell((WritableCell)label);
            CellView cellView = new CellView();
            cellView.setAutosize(true);
            this.sheet.setColumnView(i, cellView);
        }
    }

    public void addColumn(String columnName, int width) throws WriteException {
        if (width > 255) {
            throw new IllegalArgumentException("\u5bbd\u5ea6\u6700\u5927\u4e3a255[" + width + "].");
        }
        int columnCount = this.sheet.getColumns();
        WritableFont wf = new WritableFont(WritableFont.TIMES, 11, WritableFont.BOLD);
        WritableCellFormat cf = new WritableCellFormat(wf);
        Label label = new Label(columnCount, 0, columnName, (CellFormat)cf);
        this.sheet.addCell((WritableCell)label);
        this.sheet.setColumnView(columnCount, width);
    }

    public Row addRow() {
        Row row = new Row(this.sheet, this.currentRow);
        ++this.currentRow;
        return row;
    }

    public int getColumns() {
        return this.sheet.getColumns();
    }
}

