/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.boot.excel;

import io.leopard.boot.excel.Row;
import io.leopard.boot.excel.Sheet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.io.FileUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class ExcelView
extends ModelAndView {
    private String fileName;
    private ByteArrayOutputStream output;
    private WritableWorkbook workbook;
    protected String sheetName;
    private Sheet sheet;
    private int currentRow;
    private AbstractUrlBasedView view = new AbstractUrlBasedView(){

        protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            response.setContentType("application/force-download");
            String fileName = ExcelView.this.getFileName();
            if (StringUtils.isEmpty((Object)fileName)) {
                fileName = Long.toString(System.currentTimeMillis());
            }
            String filedisplay = URLEncoder.encode(fileName + ".xls", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
            ExcelView.this.workbook.write();
            ExcelView.this.workbook.close();
            ByteArrayInputStream input = new ByteArrayInputStream(ExcelView.this.output.toByteArray());
            ServletOutputStream out = response.getOutputStream();
            byte[] b = new byte[1024];
            int i = 0;
            while ((i = input.read(b)) > 0) {
                out.write(b, 0, i);
            }
            ((InputStream)input).close();
            out.flush();
            ExcelView.this.output.close();
        }
    };

    public ExcelView() throws IOException {
        this("sheet1");
    }

    public ExcelView(String sheetName) throws IOException {
        super.setView((View)this.view);
        this.output = new ByteArrayOutputStream();
        this.workbook = Workbook.createWorkbook((OutputStream)this.output);
        this.sheetName = sheetName;
    }

    public Sheet addSheet(String sheetName) {
        return new Sheet(this.workbook, sheetName);
    }

    public void addColumn(String columnName, int width) throws WriteException {
        if (this.sheet == null) {
            this.sheet = new Sheet(this.workbook, this.sheetName);
        }
        this.sheet.addColumn(columnName, width);
    }

    public void addColumnName(String ... columnNames) throws WriteException {
        this.sheet = new Sheet(this.workbook, this.sheetName);
        this.sheet.addColumnName(columnNames);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Row addRow() {
        return this.sheet.addRow();
    }

    public File save(String fileId) throws IOException, WriteException {
        File file = new File("/tmp/" + fileId + ".xls");
        this.save(file);
        return file;
    }

    public void save(File file) throws IOException, WriteException {
        this.workbook.write();
        this.workbook.close();
        FileUtils.writeByteArrayToFile((File)file, (byte[])this.output.toByteArray());
    }
}

