/*
 * Decompiled with CFR 0.152.
 */
package io.lenar.files;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.stream.Collectors;

public class ResourceFile {
    private final String fileName;

    public ResourceFile(String fileName) {
        this.fileName = fileName;
    }

    public List<String> lines() {
        return this.readLines();
    }

    public String content() {
        return this.readContent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> readLines() {
        InputStream inputStream = ResourceFile.class.getResourceAsStream("/" + this.fileName);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readContent() {
        InputStream inputStream = ResourceFile.class.getResourceAsStream("/" + this.fileName);
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

