/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V2beta1ExternalMetricSource;
import io.kubernetes.client.models.V2beta1ObjectMetricSource;
import io.kubernetes.client.models.V2beta1PodsMetricSource;
import io.kubernetes.client.models.V2beta1ResourceMetricSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).")
public class V2beta1MetricSpec {
    @SerializedName(value="external")
    private V2beta1ExternalMetricSource external = null;
    @SerializedName(value="object")
    private V2beta1ObjectMetricSource object = null;
    @SerializedName(value="pods")
    private V2beta1PodsMetricSource pods = null;
    @SerializedName(value="resource")
    private V2beta1ResourceMetricSource resource = null;
    @SerializedName(value="type")
    private String type = null;

    public V2beta1MetricSpec external(V2beta1ExternalMetricSource external) {
        this.external = external;
        return this;
    }

    @ApiModelProperty(value="external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).")
    public V2beta1ExternalMetricSource getExternal() {
        return this.external;
    }

    public void setExternal(V2beta1ExternalMetricSource external) {
        this.external = external;
    }

    public V2beta1MetricSpec object(V2beta1ObjectMetricSource object) {
        this.object = object;
        return this;
    }

    @ApiModelProperty(value="object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).")
    public V2beta1ObjectMetricSource getObject() {
        return this.object;
    }

    public void setObject(V2beta1ObjectMetricSource object) {
        this.object = object;
    }

    public V2beta1MetricSpec pods(V2beta1PodsMetricSource pods) {
        this.pods = pods;
        return this;
    }

    @ApiModelProperty(value="pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.")
    public V2beta1PodsMetricSource getPods() {
        return this.pods;
    }

    public void setPods(V2beta1PodsMetricSource pods) {
        this.pods = pods;
    }

    public V2beta1MetricSpec resource(V2beta1ResourceMetricSource resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(value="resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.")
    public V2beta1ResourceMetricSource getResource() {
        return this.resource;
    }

    public void setResource(V2beta1ResourceMetricSource resource) {
        this.resource = resource;
    }

    public V2beta1MetricSpec type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type is the type of metric source.  It should be one of \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1MetricSpec v2beta1MetricSpec = (V2beta1MetricSpec)o;
        return Objects.equals(this.external, v2beta1MetricSpec.external) && Objects.equals(this.object, v2beta1MetricSpec.object) && Objects.equals(this.pods, v2beta1MetricSpec.pods) && Objects.equals(this.resource, v2beta1MetricSpec.resource) && Objects.equals(this.type, v2beta1MetricSpec.type);
    }

    public int hashCode() {
        return Objects.hash(this.external, this.object, this.pods, this.resource, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1MetricSpec {\n");
        sb.append("    external: ").append(this.toIndentedString(this.external)).append("\n");
        sb.append("    object: ").append(this.toIndentedString(this.object)).append("\n");
        sb.append("    pods: ").append(this.toIndentedString(this.pods)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

