/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.ApiregistrationV1beta1ServiceReference;
import io.kubernetes.client.models.ApiregistrationV1beta1ServiceReferenceBuilder;
import io.kubernetes.client.models.ApiregistrationV1beta1ServiceReferenceFluentImpl;
import io.kubernetes.client.models.V1beta1APIServiceSpec;
import io.kubernetes.client.models.V1beta1APIServiceSpecFluent;
import java.util.Collection;
import java.util.List;

public class V1beta1APIServiceSpecFluentImpl<A extends V1beta1APIServiceSpecFluent<A>>
extends BaseFluent<A>
implements V1beta1APIServiceSpecFluent<A> {
    private List<Byte> caBundle;
    private String group;
    private Integer groupPriorityMinimum;
    private Boolean insecureSkipTLSVerify;
    private ApiregistrationV1beta1ServiceReferenceBuilder service;
    private String version;
    private Integer versionPriority;

    public V1beta1APIServiceSpecFluentImpl() {
    }

    public V1beta1APIServiceSpecFluentImpl(V1beta1APIServiceSpec instance) {
        this.withCaBundle(instance.getCaBundle());
        this.withGroup(instance.getGroup());
        this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());
        this.withInsecureSkipTLSVerify(instance.isInsecureSkipTLSVerify());
        this.withService(instance.getService());
        this.withVersion(instance.getVersion());
        this.withVersionPriority(instance.getVersionPriority());
    }

    @Override
    public A withCaBundle(byte ... caBundle) {
        this.caBundle.clear();
        if (caBundle != null) {
            for (byte item : caBundle) {
                this.addToCaBundle(item);
            }
        }
        return (A)this;
    }

    @Override
    public byte[] getCaBundle() {
        byte[] result = new byte[this.caBundle.size()];
        int index = 0;
        for (byte item : this.caBundle) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToCaBundle(int index, Byte item) {
        if (this.caBundle == null) {
            this.caBundle = null;
        }
        this.caBundle.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCaBundle(int index, Byte item) {
        this.caBundle.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCaBundle(Byte ... items) {
        for (Byte item : items) {
            this.caBundle.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCaBundle(Collection<Byte> items) {
        for (Byte item : items) {
            this.caBundle.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCaBundle(Byte ... items) {
        for (Byte item : items) {
            if (this.caBundle == null) continue;
            this.caBundle.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCaBundle(Collection<Byte> items) {
        for (Byte item : items) {
            if (this.caBundle == null) continue;
            this.caBundle.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCaBundle() {
        return this.caBundle != null && !this.caBundle.isEmpty();
    }

    @Override
    public A addNewCaBundle(byte arg1) {
        return this.addToCaBundle(new Byte(arg1));
    }

    @Override
    public A addNewCaBundle(String arg1) {
        return this.addToCaBundle(new Byte(arg1));
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    @Override
    public A withGroupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
        return (A)this;
    }

    @Override
    public Boolean hasGroupPriorityMinimum() {
        return this.groupPriorityMinimum != null;
    }

    @Override
    public A withNewGroupPriorityMinimum(int arg1) {
        return this.withGroupPriorityMinimum(new Integer(arg1));
    }

    @Override
    public A withNewGroupPriorityMinimum(String arg1) {
        return this.withGroupPriorityMinimum(new Integer(arg1));
    }

    @Override
    public Boolean isInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    @Override
    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
        return (A)this;
    }

    @Override
    public Boolean hasInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify != null;
    }

    @Override
    public A withNewInsecureSkipTLSVerify(boolean arg1) {
        return this.withInsecureSkipTLSVerify(new Boolean(arg1));
    }

    @Override
    public A withNewInsecureSkipTLSVerify(String arg1) {
        return this.withInsecureSkipTLSVerify(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public ApiregistrationV1beta1ServiceReference getService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public ApiregistrationV1beta1ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public A withService(ApiregistrationV1beta1ServiceReference service) {
        this._visitables.remove(this.service);
        if (service != null) {
            this.service = new ApiregistrationV1beta1ServiceReferenceBuilder(service);
            this._visitables.add(this.service);
        }
        return (A)this;
    }

    @Override
    public Boolean hasService() {
        return this.service != null;
    }

    @Override
    public V1beta1APIServiceSpecFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    @Override
    public V1beta1APIServiceSpecFluent.ServiceNested<A> withNewServiceLike(ApiregistrationV1beta1ServiceReference item) {
        return new ServiceNestedImpl(item);
    }

    @Override
    public V1beta1APIServiceSpecFluent.ServiceNested<A> editService() {
        return this.withNewServiceLike(this.getService());
    }

    @Override
    public V1beta1APIServiceSpecFluent.ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : new ApiregistrationV1beta1ServiceReferenceBuilder().build());
    }

    @Override
    public V1beta1APIServiceSpecFluent.ServiceNested<A> editOrNewServiceLike(ApiregistrationV1beta1ServiceReference item) {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : item);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public Integer getVersionPriority() {
        return this.versionPriority;
    }

    @Override
    public A withVersionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
        return (A)this;
    }

    @Override
    public Boolean hasVersionPriority() {
        return this.versionPriority != null;
    }

    @Override
    public A withNewVersionPriority(int arg1) {
        return this.withVersionPriority(new Integer(arg1));
    }

    @Override
    public A withNewVersionPriority(String arg1) {
        return this.withVersionPriority(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta1APIServiceSpecFluentImpl that = (V1beta1APIServiceSpecFluentImpl)o;
        if (this.caBundle != null ? !this.caBundle.equals(that.caBundle) : that.caBundle != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.groupPriorityMinimum != null ? !this.groupPriorityMinimum.equals(that.groupPriorityMinimum) : that.groupPriorityMinimum != null) {
            return false;
        }
        if (this.insecureSkipTLSVerify != null ? !this.insecureSkipTLSVerify.equals(that.insecureSkipTLSVerify) : that.insecureSkipTLSVerify != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return !(this.versionPriority != null ? !this.versionPriority.equals(that.versionPriority) : that.versionPriority != null);
    }

    public class ServiceNestedImpl<N>
    extends ApiregistrationV1beta1ServiceReferenceFluentImpl<V1beta1APIServiceSpecFluent.ServiceNested<N>>
    implements V1beta1APIServiceSpecFluent.ServiceNested<N>,
    Nested<N> {
        private final ApiregistrationV1beta1ServiceReferenceBuilder builder;

        ServiceNestedImpl(ApiregistrationV1beta1ServiceReference item) {
            this.builder = new ApiregistrationV1beta1ServiceReferenceBuilder(this, item);
        }

        ServiceNestedImpl() {
            this.builder = new ApiregistrationV1beta1ServiceReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1APIServiceSpecFluentImpl.this.withService(this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }
}

