/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.ExtensionsV1beta1AllowedFlexVolume;
import io.kubernetes.client.models.ExtensionsV1beta1AllowedHostPath;
import io.kubernetes.client.models.ExtensionsV1beta1FSGroupStrategyOptions;
import io.kubernetes.client.models.ExtensionsV1beta1HostPortRange;
import io.kubernetes.client.models.ExtensionsV1beta1RunAsUserStrategyOptions;
import io.kubernetes.client.models.ExtensionsV1beta1SELinuxStrategyOptions;
import io.kubernetes.client.models.ExtensionsV1beta1SupplementalGroupsStrategyOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="PodSecurityPolicySpec defines the policy enforced. Deprecated: use PodSecurityPolicySpec from policy API Group instead.")
public class ExtensionsV1beta1PodSecurityPolicySpec {
    @SerializedName(value="allowPrivilegeEscalation")
    private Boolean allowPrivilegeEscalation = null;
    @SerializedName(value="allowedCapabilities")
    private List<String> allowedCapabilities = null;
    @SerializedName(value="allowedFlexVolumes")
    private List<ExtensionsV1beta1AllowedFlexVolume> allowedFlexVolumes = null;
    @SerializedName(value="allowedHostPaths")
    private List<ExtensionsV1beta1AllowedHostPath> allowedHostPaths = null;
    @SerializedName(value="allowedUnsafeSysctls")
    private List<String> allowedUnsafeSysctls = null;
    @SerializedName(value="defaultAddCapabilities")
    private List<String> defaultAddCapabilities = null;
    @SerializedName(value="defaultAllowPrivilegeEscalation")
    private Boolean defaultAllowPrivilegeEscalation = null;
    @SerializedName(value="forbiddenSysctls")
    private List<String> forbiddenSysctls = null;
    @SerializedName(value="fsGroup")
    private ExtensionsV1beta1FSGroupStrategyOptions fsGroup = null;
    @SerializedName(value="hostIPC")
    private Boolean hostIPC = null;
    @SerializedName(value="hostNetwork")
    private Boolean hostNetwork = null;
    @SerializedName(value="hostPID")
    private Boolean hostPID = null;
    @SerializedName(value="hostPorts")
    private List<ExtensionsV1beta1HostPortRange> hostPorts = null;
    @SerializedName(value="privileged")
    private Boolean privileged = null;
    @SerializedName(value="readOnlyRootFilesystem")
    private Boolean readOnlyRootFilesystem = null;
    @SerializedName(value="requiredDropCapabilities")
    private List<String> requiredDropCapabilities = null;
    @SerializedName(value="runAsUser")
    private ExtensionsV1beta1RunAsUserStrategyOptions runAsUser = null;
    @SerializedName(value="seLinux")
    private ExtensionsV1beta1SELinuxStrategyOptions seLinux = null;
    @SerializedName(value="supplementalGroups")
    private ExtensionsV1beta1SupplementalGroupsStrategyOptions supplementalGroups = null;
    @SerializedName(value="volumes")
    private List<String> volumes = null;

    public ExtensionsV1beta1PodSecurityPolicySpec allowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return this;
    }

    @ApiModelProperty(value="allowPrivilegeEscalation determines if a pod can request to allow privilege escalation. If unspecified, defaults to true.")
    public Boolean isAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec allowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities = allowedCapabilities;
        return this;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec addAllowedCapabilitiesItem(String allowedCapabilitiesItem) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        this.allowedCapabilities.add(allowedCapabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="allowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both allowedCapabilities and requiredDropCapabilities.")
    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    public void setAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities = allowedCapabilities;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec allowedFlexVolumes(List<ExtensionsV1beta1AllowedFlexVolume> allowedFlexVolumes) {
        this.allowedFlexVolumes = allowedFlexVolumes;
        return this;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec addAllowedFlexVolumesItem(ExtensionsV1beta1AllowedFlexVolume allowedFlexVolumesItem) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<ExtensionsV1beta1AllowedFlexVolume>();
        }
        this.allowedFlexVolumes.add(allowedFlexVolumesItem);
        return this;
    }

    @ApiModelProperty(value="allowedFlexVolumes is a whitelist of allowed Flexvolumes.  Empty or nil indicates that all Flexvolumes may be used.  This parameter is effective only when the usage of the Flexvolumes is allowed in the \"volumes\" field.")
    public List<ExtensionsV1beta1AllowedFlexVolume> getAllowedFlexVolumes() {
        return this.allowedFlexVolumes;
    }

    public void setAllowedFlexVolumes(List<ExtensionsV1beta1AllowedFlexVolume> allowedFlexVolumes) {
        this.allowedFlexVolumes = allowedFlexVolumes;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec allowedHostPaths(List<ExtensionsV1beta1AllowedHostPath> allowedHostPaths) {
        this.allowedHostPaths = allowedHostPaths;
        return this;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec addAllowedHostPathsItem(ExtensionsV1beta1AllowedHostPath allowedHostPathsItem) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList<ExtensionsV1beta1AllowedHostPath>();
        }
        this.allowedHostPaths.add(allowedHostPathsItem);
        return this;
    }

    @ApiModelProperty(value="allowedHostPaths is a white list of allowed host paths. Empty indicates that all host paths may be used.")
    public List<ExtensionsV1beta1AllowedHostPath> getAllowedHostPaths() {
        return this.allowedHostPaths;
    }

    public void setAllowedHostPaths(List<ExtensionsV1beta1AllowedHostPath> allowedHostPaths) {
        this.allowedHostPaths = allowedHostPaths;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec allowedUnsafeSysctls(List<String> allowedUnsafeSysctls) {
        this.allowedUnsafeSysctls = allowedUnsafeSysctls;
        return this;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec addAllowedUnsafeSysctlsItem(String allowedUnsafeSysctlsItem) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        this.allowedUnsafeSysctls.add(allowedUnsafeSysctlsItem);
        return this;
    }

    @ApiModelProperty(value="allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none. Each entry is either a plain sysctl name or ends in \"*\" in which case it is considered as a prefix of allowed sysctls. Single * means all unsafe sysctls are allowed. Kubelet has to whitelist all allowed unsafe sysctls explicitly to avoid rejection.  Examples: e.g. \"foo/_*\" allows \"foo/bar\", \"foo/baz\", etc. e.g. \"foo.*\" allows \"foo.bar\", \"foo.baz\", etc.")
    public List<String> getAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls;
    }

    public void setAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls) {
        this.allowedUnsafeSysctls = allowedUnsafeSysctls;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec defaultAddCapabilities(List<String> defaultAddCapabilities) {
        this.defaultAddCapabilities = defaultAddCapabilities;
        return this;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec addDefaultAddCapabilitiesItem(String defaultAddCapabilitiesItem) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        this.defaultAddCapabilities.add(defaultAddCapabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capability in both defaultAddCapabilities and requiredDropCapabilities. Capabilities added here are implicitly allowed, and need not be included in the allowedCapabilities list.")
    public List<String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    public void setDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        this.defaultAddCapabilities = defaultAddCapabilities;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec defaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation) {
        this.defaultAllowPrivilegeEscalation = defaultAllowPrivilegeEscalation;
        return this;
    }

    @ApiModelProperty(value="defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process.")
    public Boolean isDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation;
    }

    public void setDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation) {
        this.defaultAllowPrivilegeEscalation = defaultAllowPrivilegeEscalation;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec forbiddenSysctls(List<String> forbiddenSysctls) {
        this.forbiddenSysctls = forbiddenSysctls;
        return this;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec addForbiddenSysctlsItem(String forbiddenSysctlsItem) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        this.forbiddenSysctls.add(forbiddenSysctlsItem);
        return this;
    }

    @ApiModelProperty(value="forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none. Each entry is either a plain sysctl name or ends in \"*\" in which case it is considered as a prefix of forbidden sysctls. Single * means all sysctls are forbidden.  Examples: e.g. \"foo/_*\" forbids \"foo/bar\", \"foo/baz\", etc. e.g. \"foo.*\" forbids \"foo.bar\", \"foo.baz\", etc.")
    public List<String> getForbiddenSysctls() {
        return this.forbiddenSysctls;
    }

    public void setForbiddenSysctls(List<String> forbiddenSysctls) {
        this.forbiddenSysctls = forbiddenSysctls;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec fsGroup(ExtensionsV1beta1FSGroupStrategyOptions fsGroup) {
        this.fsGroup = fsGroup;
        return this;
    }

    @ApiModelProperty(required=true, value="fsGroup is the strategy that will dictate what fs group is used by the SecurityContext.")
    public ExtensionsV1beta1FSGroupStrategyOptions getFsGroup() {
        return this.fsGroup;
    }

    public void setFsGroup(ExtensionsV1beta1FSGroupStrategyOptions fsGroup) {
        this.fsGroup = fsGroup;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec hostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return this;
    }

    @ApiModelProperty(value="hostIPC determines if the policy allows the use of HostIPC in the pod spec.")
    public Boolean isHostIPC() {
        return this.hostIPC;
    }

    public void setHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec hostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return this;
    }

    @ApiModelProperty(value="hostNetwork determines if the policy allows the use of HostNetwork in the pod spec.")
    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    public void setHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec hostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return this;
    }

    @ApiModelProperty(value="hostPID determines if the policy allows the use of HostPID in the pod spec.")
    public Boolean isHostPID() {
        return this.hostPID;
    }

    public void setHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec hostPorts(List<ExtensionsV1beta1HostPortRange> hostPorts) {
        this.hostPorts = hostPorts;
        return this;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec addHostPortsItem(ExtensionsV1beta1HostPortRange hostPortsItem) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList<ExtensionsV1beta1HostPortRange>();
        }
        this.hostPorts.add(hostPortsItem);
        return this;
    }

    @ApiModelProperty(value="hostPorts determines which host port ranges are allowed to be exposed.")
    public List<ExtensionsV1beta1HostPortRange> getHostPorts() {
        return this.hostPorts;
    }

    public void setHostPorts(List<ExtensionsV1beta1HostPortRange> hostPorts) {
        this.hostPorts = hostPorts;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec privileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @ApiModelProperty(value="privileged determines if a pod can request to be run as privileged.")
    public Boolean isPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec readOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return this;
    }

    @ApiModelProperty(value="readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.")
    public Boolean isReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec requiredDropCapabilities(List<String> requiredDropCapabilities) {
        this.requiredDropCapabilities = requiredDropCapabilities;
        return this;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec addRequiredDropCapabilitiesItem(String requiredDropCapabilitiesItem) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        this.requiredDropCapabilities.add(requiredDropCapabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="requiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.")
    public List<String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    public void setRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        this.requiredDropCapabilities = requiredDropCapabilities;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec runAsUser(ExtensionsV1beta1RunAsUserStrategyOptions runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @ApiModelProperty(required=true, value="runAsUser is the strategy that will dictate the allowable RunAsUser values that may be set.")
    public ExtensionsV1beta1RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(ExtensionsV1beta1RunAsUserStrategyOptions runAsUser) {
        this.runAsUser = runAsUser;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec seLinux(ExtensionsV1beta1SELinuxStrategyOptions seLinux) {
        this.seLinux = seLinux;
        return this;
    }

    @ApiModelProperty(required=true, value="seLinux is the strategy that will dictate the allowable labels that may be set.")
    public ExtensionsV1beta1SELinuxStrategyOptions getSeLinux() {
        return this.seLinux;
    }

    public void setSeLinux(ExtensionsV1beta1SELinuxStrategyOptions seLinux) {
        this.seLinux = seLinux;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec supplementalGroups(ExtensionsV1beta1SupplementalGroupsStrategyOptions supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
        return this;
    }

    @ApiModelProperty(required=true, value="supplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.")
    public ExtensionsV1beta1SupplementalGroupsStrategyOptions getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public void setSupplementalGroups(ExtensionsV1beta1SupplementalGroupsStrategyOptions supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec volumes(List<String> volumes) {
        this.volumes = volumes;
        return this;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec addVolumesItem(String volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @ApiModelProperty(value="volumes is a white list of allowed volume plugins. Empty indicates that no volumes may be used. To allow all volumes you may use '*'.")
    public List<String> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionsV1beta1PodSecurityPolicySpec extensionsV1beta1PodSecurityPolicySpec = (ExtensionsV1beta1PodSecurityPolicySpec)o;
        return Objects.equals(this.allowPrivilegeEscalation, extensionsV1beta1PodSecurityPolicySpec.allowPrivilegeEscalation) && Objects.equals(this.allowedCapabilities, extensionsV1beta1PodSecurityPolicySpec.allowedCapabilities) && Objects.equals(this.allowedFlexVolumes, extensionsV1beta1PodSecurityPolicySpec.allowedFlexVolumes) && Objects.equals(this.allowedHostPaths, extensionsV1beta1PodSecurityPolicySpec.allowedHostPaths) && Objects.equals(this.allowedUnsafeSysctls, extensionsV1beta1PodSecurityPolicySpec.allowedUnsafeSysctls) && Objects.equals(this.defaultAddCapabilities, extensionsV1beta1PodSecurityPolicySpec.defaultAddCapabilities) && Objects.equals(this.defaultAllowPrivilegeEscalation, extensionsV1beta1PodSecurityPolicySpec.defaultAllowPrivilegeEscalation) && Objects.equals(this.forbiddenSysctls, extensionsV1beta1PodSecurityPolicySpec.forbiddenSysctls) && Objects.equals(this.fsGroup, extensionsV1beta1PodSecurityPolicySpec.fsGroup) && Objects.equals(this.hostIPC, extensionsV1beta1PodSecurityPolicySpec.hostIPC) && Objects.equals(this.hostNetwork, extensionsV1beta1PodSecurityPolicySpec.hostNetwork) && Objects.equals(this.hostPID, extensionsV1beta1PodSecurityPolicySpec.hostPID) && Objects.equals(this.hostPorts, extensionsV1beta1PodSecurityPolicySpec.hostPorts) && Objects.equals(this.privileged, extensionsV1beta1PodSecurityPolicySpec.privileged) && Objects.equals(this.readOnlyRootFilesystem, extensionsV1beta1PodSecurityPolicySpec.readOnlyRootFilesystem) && Objects.equals(this.requiredDropCapabilities, extensionsV1beta1PodSecurityPolicySpec.requiredDropCapabilities) && Objects.equals(this.runAsUser, extensionsV1beta1PodSecurityPolicySpec.runAsUser) && Objects.equals(this.seLinux, extensionsV1beta1PodSecurityPolicySpec.seLinux) && Objects.equals(this.supplementalGroups, extensionsV1beta1PodSecurityPolicySpec.supplementalGroups) && Objects.equals(this.volumes, extensionsV1beta1PodSecurityPolicySpec.volumes);
    }

    public int hashCode() {
        return Objects.hash(this.allowPrivilegeEscalation, this.allowedCapabilities, this.allowedFlexVolumes, this.allowedHostPaths, this.allowedUnsafeSysctls, this.defaultAddCapabilities, this.defaultAllowPrivilegeEscalation, this.forbiddenSysctls, this.fsGroup, this.hostIPC, this.hostNetwork, this.hostPID, this.hostPorts, this.privileged, this.readOnlyRootFilesystem, this.requiredDropCapabilities, this.runAsUser, this.seLinux, this.supplementalGroups, this.volumes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtensionsV1beta1PodSecurityPolicySpec {\n");
        sb.append("    allowPrivilegeEscalation: ").append(this.toIndentedString(this.allowPrivilegeEscalation)).append("\n");
        sb.append("    allowedCapabilities: ").append(this.toIndentedString(this.allowedCapabilities)).append("\n");
        sb.append("    allowedFlexVolumes: ").append(this.toIndentedString(this.allowedFlexVolumes)).append("\n");
        sb.append("    allowedHostPaths: ").append(this.toIndentedString(this.allowedHostPaths)).append("\n");
        sb.append("    allowedUnsafeSysctls: ").append(this.toIndentedString(this.allowedUnsafeSysctls)).append("\n");
        sb.append("    defaultAddCapabilities: ").append(this.toIndentedString(this.defaultAddCapabilities)).append("\n");
        sb.append("    defaultAllowPrivilegeEscalation: ").append(this.toIndentedString(this.defaultAllowPrivilegeEscalation)).append("\n");
        sb.append("    forbiddenSysctls: ").append(this.toIndentedString(this.forbiddenSysctls)).append("\n");
        sb.append("    fsGroup: ").append(this.toIndentedString(this.fsGroup)).append("\n");
        sb.append("    hostIPC: ").append(this.toIndentedString(this.hostIPC)).append("\n");
        sb.append("    hostNetwork: ").append(this.toIndentedString(this.hostNetwork)).append("\n");
        sb.append("    hostPID: ").append(this.toIndentedString(this.hostPID)).append("\n");
        sb.append("    hostPorts: ").append(this.toIndentedString(this.hostPorts)).append("\n");
        sb.append("    privileged: ").append(this.toIndentedString(this.privileged)).append("\n");
        sb.append("    readOnlyRootFilesystem: ").append(this.toIndentedString(this.readOnlyRootFilesystem)).append("\n");
        sb.append("    requiredDropCapabilities: ").append(this.toIndentedString(this.requiredDropCapabilities)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    seLinux: ").append(this.toIndentedString(this.seLinux)).append("\n");
        sb.append("    supplementalGroups: ").append(this.toIndentedString(this.supplementalGroups)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

