/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1PodTemplateSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="JobSpec describes how the job execution will look like.")
public class V1JobSpec {
    @SerializedName(value="activeDeadlineSeconds")
    private Long activeDeadlineSeconds = null;
    @SerializedName(value="backoffLimit")
    private Integer backoffLimit = null;
    @SerializedName(value="completions")
    private Integer completions = null;
    @SerializedName(value="manualSelector")
    private Boolean manualSelector = null;
    @SerializedName(value="parallelism")
    private Integer parallelism = null;
    @SerializedName(value="selector")
    private V1LabelSelector selector = null;
    @SerializedName(value="template")
    private V1PodTemplateSpec template = null;

    public V1JobSpec activeDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return this;
    }

    @ApiModelProperty(value="Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it; value must be positive integer")
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public void setActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public V1JobSpec backoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return this;
    }

    @ApiModelProperty(value="Specifies the number of retries before marking this job failed. Defaults to 6")
    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public void setBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
    }

    public V1JobSpec completions(Integer completions) {
        this.completions = completions;
        return this;
    }

    @ApiModelProperty(value="Specifies the desired number of successfully finished pods the job should be run with.  Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    public Integer getCompletions() {
        return this.completions;
    }

    public void setCompletions(Integer completions) {
        this.completions = completions;
    }

    public V1JobSpec manualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
        return this;
    }

    @ApiModelProperty(value="manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector")
    public Boolean isManualSelector() {
        return this.manualSelector;
    }

    public void setManualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
    }

    public V1JobSpec parallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @ApiModelProperty(value="Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    public Integer getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public V1JobSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(value="A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1JobSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="Describes the pod that will be created when executing a job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1JobSpec v1JobSpec = (V1JobSpec)o;
        return Objects.equals(this.activeDeadlineSeconds, v1JobSpec.activeDeadlineSeconds) && Objects.equals(this.backoffLimit, v1JobSpec.backoffLimit) && Objects.equals(this.completions, v1JobSpec.completions) && Objects.equals(this.manualSelector, v1JobSpec.manualSelector) && Objects.equals(this.parallelism, v1JobSpec.parallelism) && Objects.equals(this.selector, v1JobSpec.selector) && Objects.equals(this.template, v1JobSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.backoffLimit, this.completions, this.manualSelector, this.parallelism, this.selector, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1JobSpec {\n");
        sb.append("    activeDeadlineSeconds: ").append(this.toIndentedString(this.activeDeadlineSeconds)).append("\n");
        sb.append("    backoffLimit: ").append(this.toIndentedString(this.backoffLimit)).append("\n");
        sb.append("    completions: ").append(this.toIndentedString(this.completions)).append("\n");
        sb.append("    manualSelector: ").append(this.toIndentedString(this.manualSelector)).append("\n");
        sb.append("    parallelism: ").append(this.toIndentedString(this.parallelism)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

