/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Rule is a tuple of APIGroups, APIVersion, and Resources.It is recommended to make sure that all the tuple expansions are valid.")
public class V1alpha1Rule {
    @SerializedName(value="apiGroups")
    private List<String> apiGroups = null;
    @SerializedName(value="apiVersions")
    private List<String> apiVersions = null;
    @SerializedName(value="resources")
    private List<String> resources = null;

    public V1alpha1Rule apiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1alpha1Rule addApiGroupsItem(String apiGroupsItem) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    @ApiModelProperty(value="APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.")
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1alpha1Rule apiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public V1alpha1Rule addApiVersionsItem(String apiVersionsItem) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.add(apiVersionsItem);
        return this;
    }

    @ApiModelProperty(value="APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.")
    public List<String> getApiVersions() {
        return this.apiVersions;
    }

    public void setApiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
    }

    public V1alpha1Rule resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public V1alpha1Rule addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @ApiModelProperty(value="Resources is a list of resources this rule applies to.  For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/_*' means all subresources of pods. '*_/scale' means all scale subresources. '*_/_*' means all resources and their subresources.  If wildcard is present, the validation rule will ensure resources do not overlap with each other.  Depending on the enclosing object, subresources might not be allowed. Required.")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1Rule v1alpha1Rule = (V1alpha1Rule)o;
        return Objects.equals(this.apiGroups, v1alpha1Rule.apiGroups) && Objects.equals(this.apiVersions, v1alpha1Rule.apiVersions) && Objects.equals(this.resources, v1alpha1Rule.resources);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.apiVersions, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1Rule {\n");
        sb.append("    apiGroups: ").append(this.toIndentedString(this.apiGroups)).append("\n");
        sb.append("    apiVersions: ").append(this.toIndentedString(this.apiVersions)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

