/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="ResourceQuotaStatus defines the enforced hard limits and observed use.")
public class V1ResourceQuotaStatus {
    @SerializedName(value="hard")
    private Map<String, String> hard = null;
    @SerializedName(value="used")
    private Map<String, String> used = null;

    public V1ResourceQuotaStatus hard(Map<String, String> hard) {
        this.hard = hard;
        return this;
    }

    public V1ResourceQuotaStatus putHardItem(String key, String hardItem) {
        if (this.hard == null) {
            this.hard = new HashMap<String, String>();
        }
        this.hard.put(key, hardItem);
        return this;
    }

    @ApiModelProperty(value="Hard is the set of enforced hard limits for each named resource. More info: https://git.k8s.io/community/contributors/design-proposals/admission_control_resource_quota.md")
    public Map<String, String> getHard() {
        return this.hard;
    }

    public void setHard(Map<String, String> hard) {
        this.hard = hard;
    }

    public V1ResourceQuotaStatus used(Map<String, String> used) {
        this.used = used;
        return this;
    }

    public V1ResourceQuotaStatus putUsedItem(String key, String usedItem) {
        if (this.used == null) {
            this.used = new HashMap<String, String>();
        }
        this.used.put(key, usedItem);
        return this;
    }

    @ApiModelProperty(value="Used is the current observed total usage of the resource in the namespace.")
    public Map<String, String> getUsed() {
        return this.used;
    }

    public void setUsed(Map<String, String> used) {
        this.used = used;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceQuotaStatus v1ResourceQuotaStatus = (V1ResourceQuotaStatus)o;
        return Objects.equals(this.hard, v1ResourceQuotaStatus.hard) && Objects.equals(this.used, v1ResourceQuotaStatus.used);
    }

    public int hashCode() {
        return Objects.hash(this.hard, this.used);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceQuotaStatus {\n");
        sb.append("    hard: ").append(this.toIndentedString(this.hard)).append("\n");
        sb.append("    used: ").append(this.toIndentedString(this.used)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

