/*
* Copyright 2014-2021 JetBrains s.r.o and contributors. Use of this source code is governed by the Apache 2.0 license.
*/

package io.ktor.client.engine.darwin.certificates

@SharedImmutable
private val rsa1024Asn1Header: IntArray = intArrayOf(
    0x30, 0x81, 0x9F, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
    0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 0x8D, 0x00
)

@SharedImmutable
private val rsa2048Asn1Header: IntArray = intArrayOf(
    0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86,
    0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00
)

@SharedImmutable
private val rsa3072Asn1Header: IntArray = intArrayOf(
    0x30, 0x82, 0x01, 0xA2, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86,
    0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x8F, 0x00
)

@SharedImmutable
private val rsa4096Asn1Header: IntArray = intArrayOf(
    0x30, 0x82, 0x02, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86,
    0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x02, 0x0F, 0x00
)

@SharedImmutable
private val ecdsaSecp256r1Asn1Header: IntArray = intArrayOf(
    0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
    0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
    0x42, 0x00
)

@SharedImmutable
private val ecdsaSecp384r1Asn1Header: IntArray = intArrayOf(
    0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
    0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00
)

/**
 * Certificate headers
 *
 * Sources for values:
 * https://github.com/datatheorem/TrustKit/blob/master/TrustKit/Pinning/TSKSPKIHashCache.m
 * https://github.com/IBM-Swift/BlueRSA/blob/master/Sources/CryptorRSA/CryptorRSAUtilities.swift
 */
internal object CertificatesInfo {
    val rsa = mapOf(
        1024 to rsa1024Asn1Header,
        2048 to rsa2048Asn1Header,
        3072 to rsa3072Asn1Header,
        4096 to rsa4096Asn1Header
    )

    val ecdsa = mapOf(
        256 to ecdsaSecp256r1Asn1Header,
        384 to ecdsaSecp384r1Asn1Header
    )

    internal const val HASH_ALGORITHM_SHA_256 = "sha256/"
    internal const val HASH_ALGORITHM_SHA_1 = "sha1/"
}
