/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.ktor.client;

import io.kotest.assertions.ktor.client.HeadersKt;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpProtocolVersion;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0004\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u001a\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003H\u0086\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0001\u001a\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003H\u0086\u0004\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0001\u001a\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\u0003H\u0086\u0004\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0001\u001a\u0015\u0010\n\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\u0003H\u0086\u0004\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0001\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003H\u0086\u0004\u001a\u001a\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003\u001a\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003H\u0086\u0004\u001a\u001a\u0010\u000e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003\u001a\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010\u0012\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0015\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0004\u001a\u0015\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0004\u001a\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0015\u0010\u001a\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0004\u001a\u0015\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0004\u001a\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u0003\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003\u00a8\u0006 "}, d2={"shouldHaveETag", "Lio/ktor/client/statement/HttpResponse;", "etag", "", "shouldNotHaveETag", "shouldHaveCacheControl", "cacheControl", "shouldNotHaveCacheControl", "shouldHaveContentEncoding", "encoding", "shouldNotHaveContentEncoding", "shouldHaveHeader", "name", "value", "shouldNotHaveHeader", "shouldHaveVersion", "version", "Lio/ktor/http/HttpProtocolVersion;", "shouldNotHaveVersion", "haveVersion", "Lio/kotest/matchers/Matcher;", "shouldHaveContentType", "contentType", "Lio/ktor/http/ContentType;", "shouldNotHaveContentType", "haveContentType", "shouldHaveContentTypeMatching", "shouldNotHaveContentTypeMatching", "haveContentTypeMatching", "haveHeader", "headerName", "headerValue", "kotest-assertions-ktor"})
public final class HeadersKt {
    @NotNull
    public static final HttpResponse shouldHaveETag(@NotNull HttpResponse $this$shouldHaveETag, @NotNull String etag) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveETag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)etag, (String)"etag");
        ShouldKt.should((Object)$this$shouldHaveETag, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getETag(), etag));
        return $this$shouldHaveETag;
    }

    @NotNull
    public static final HttpResponse shouldHaveETag(@NotNull HttpResponse $this$shouldHaveETag) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveETag, (String)"<this>");
        ShouldKt.should((Object)$this$shouldHaveETag, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getETag()));
        return $this$shouldHaveETag;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveETag(@NotNull HttpResponse $this$shouldNotHaveETag, @NotNull String etag) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveETag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)etag, (String)"etag");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveETag, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getETag(), etag));
        return $this$shouldNotHaveETag;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveETag(@NotNull HttpResponse $this$shouldNotHaveETag) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveETag, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveETag, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getETag()));
        return $this$shouldNotHaveETag;
    }

    @NotNull
    public static final HttpResponse shouldHaveCacheControl(@NotNull HttpResponse $this$shouldHaveCacheControl, @NotNull String cacheControl) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveCacheControl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cacheControl, (String)"cacheControl");
        ShouldKt.should((Object)$this$shouldHaveCacheControl, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getCacheControl(), cacheControl));
        return $this$shouldHaveCacheControl;
    }

    @NotNull
    public static final HttpResponse shouldHaveCacheControl(@NotNull HttpResponse $this$shouldHaveCacheControl) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveCacheControl, (String)"<this>");
        ShouldKt.should((Object)$this$shouldHaveCacheControl, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getCacheControl()));
        return $this$shouldHaveCacheControl;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveCacheControl(@NotNull HttpResponse $this$shouldNotHaveCacheControl, @NotNull String cacheControl) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveCacheControl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cacheControl, (String)"cacheControl");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveCacheControl, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getCacheControl(), cacheControl));
        return $this$shouldNotHaveCacheControl;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveCacheControl(@NotNull HttpResponse $this$shouldNotHaveCacheControl) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveCacheControl, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveCacheControl, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getCacheControl()));
        return $this$shouldNotHaveCacheControl;
    }

    @NotNull
    public static final HttpResponse shouldHaveContentEncoding(@NotNull HttpResponse $this$shouldHaveContentEncoding, @NotNull String encoding) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveContentEncoding, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        ShouldKt.should((Object)$this$shouldHaveContentEncoding, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getContentEncoding(), encoding));
        return $this$shouldHaveContentEncoding;
    }

    @NotNull
    public static final HttpResponse shouldHaveContentEncoding(@NotNull HttpResponse $this$shouldHaveContentEncoding) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveContentEncoding, (String)"<this>");
        ShouldKt.should((Object)$this$shouldHaveContentEncoding, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getContentEncoding()));
        return $this$shouldHaveContentEncoding;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveContentEncoding(@NotNull HttpResponse $this$shouldNotHaveContentEncoding, @NotNull String encoding) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveContentEncoding, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveContentEncoding, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getContentEncoding(), encoding));
        return $this$shouldNotHaveContentEncoding;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveContentEncoding(@NotNull HttpResponse $this$shouldNotHaveContentEncoding) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveContentEncoding, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveContentEncoding, HeadersKt.haveHeader(HttpHeaders.INSTANCE.getContentEncoding()));
        return $this$shouldNotHaveContentEncoding;
    }

    @NotNull
    public static final HttpResponse shouldHaveHeader(@NotNull HttpResponse $this$shouldHaveHeader, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldHaveHeader, HeadersKt.haveHeader(name));
        return $this$shouldHaveHeader;
    }

    @NotNull
    public static final HttpResponse shouldHaveHeader(@NotNull HttpResponse $this$shouldHaveHeader, @NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ShouldKt.should((Object)$this$shouldHaveHeader, HeadersKt.haveHeader(name, value));
        return $this$shouldHaveHeader;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveHeader(@NotNull HttpResponse $this$shouldNotHaveHeader, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveHeader, HeadersKt.haveHeader(name));
        return $this$shouldNotHaveHeader;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveHeader(@NotNull HttpResponse $this$shouldNotHaveHeader, @NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveHeader, HeadersKt.haveHeader(name, value));
        return $this$shouldNotHaveHeader;
    }

    @NotNull
    public static final HttpResponse shouldHaveVersion(@NotNull HttpResponse $this$shouldHaveVersion, @NotNull HttpProtocolVersion version) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveVersion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        ShouldKt.should((Object)$this$shouldHaveVersion, HeadersKt.haveVersion(version));
        return $this$shouldHaveVersion;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveVersion(@NotNull HttpResponse $this$shouldNotHaveVersion, @NotNull HttpProtocolVersion version) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveVersion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveVersion, HeadersKt.haveVersion(version));
        return $this$shouldNotHaveVersion;
    }

    @NotNull
    public static final Matcher<HttpResponse> haveVersion(@NotNull HttpProtocolVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return (Matcher)new Matcher<HttpResponse>(version){
            final /* synthetic */ HttpProtocolVersion $version;
            {
                this.$version = $version;
            }

            public MatcherResult test(HttpResponse value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)value.getVersion(), (Object)this.$version), () -> haveVersion.1.test$lambda$0(this.$version, value), () -> haveVersion.1.test$lambda$1(this.$version));
            }

            public Matcher<HttpResponse> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends HttpResponse> f) {
                return super.contramap(f);
            }

            public Matcher<HttpResponse> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(HttpProtocolVersion $version, HttpResponse $value) {
                return "Response should have version " + $version + " but was " + $value.getVersion();
            }

            private static final String test$lambda$1(HttpProtocolVersion $version) {
                return "Response should not have version " + $version;
            }
        };
    }

    @NotNull
    public static final HttpResponse shouldHaveContentType(@NotNull HttpResponse $this$shouldHaveContentType, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveContentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        ShouldKt.should((Object)$this$shouldHaveContentType, HeadersKt.haveContentType(contentType));
        return $this$shouldHaveContentType;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveContentType(@NotNull HttpResponse $this$shouldNotHaveContentType, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveContentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveContentType, HeadersKt.haveContentType(contentType));
        return $this$shouldNotHaveContentType;
    }

    @NotNull
    public static final Matcher<HttpResponse> haveContentType(@NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        return (Matcher)new Matcher<HttpResponse>(contentType){
            final /* synthetic */ ContentType $contentType;
            {
                this.$contentType = $contentType;
            }

            public MatcherResult test(HttpResponse value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)HttpMessagePropertiesKt.contentType((HttpMessage)((HttpMessage)value)), (Object)this.$contentType), () -> haveContentType.1.test$lambda$0(this.$contentType, value), () -> haveContentType.1.test$lambda$1(this.$contentType));
            }

            public Matcher<HttpResponse> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends HttpResponse> f) {
                return super.contramap(f);
            }

            public Matcher<HttpResponse> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(ContentType $contentType, HttpResponse $value) {
                return "Response should have Content-Type " + $contentType + " but was " + HttpMessagePropertiesKt.contentType((HttpMessage)((HttpMessage)$value)) + ".";
            }

            private static final String test$lambda$1(ContentType $contentType) {
                return "Response should not have Content-Type " + $contentType + ".";
            }
        };
    }

    @NotNull
    public static final HttpResponse shouldHaveContentTypeMatching(@NotNull HttpResponse $this$shouldHaveContentTypeMatching, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveContentTypeMatching, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        ShouldKt.should((Object)$this$shouldHaveContentTypeMatching, HeadersKt.haveContentTypeMatching(contentType));
        return $this$shouldHaveContentTypeMatching;
    }

    @NotNull
    public static final HttpResponse shouldNotHaveContentTypeMatching(@NotNull HttpResponse $this$shouldNotHaveContentTypeMatching, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveContentTypeMatching, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveContentTypeMatching, HeadersKt.haveContentTypeMatching(contentType));
        return $this$shouldNotHaveContentTypeMatching;
    }

    @NotNull
    public static final Matcher<HttpResponse> haveContentTypeMatching(@NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        return (Matcher)new Matcher<HttpResponse>(contentType){
            final /* synthetic */ ContentType $contentType;
            {
                this.$contentType = $contentType;
            }

            public MatcherResult test(HttpResponse value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ContentType contentType = HttpMessagePropertiesKt.contentType((HttpMessage)((HttpMessage)value));
                return MatcherResult.Companion.invoke(contentType != null ? contentType.match(this.$contentType) : false, () -> haveContentTypeMatching.1.test$lambda$0(this.$contentType, value), () -> haveContentTypeMatching.1.test$lambda$1(this.$contentType));
            }

            public Matcher<HttpResponse> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends HttpResponse> f) {
                return super.contramap(f);
            }

            public Matcher<HttpResponse> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(ContentType $contentType, HttpResponse $value) {
                return "Response should match Content-Type " + $contentType + " but was " + HttpMessagePropertiesKt.contentType((HttpMessage)((HttpMessage)$value)) + ".";
            }

            private static final String test$lambda$1(ContentType $contentType) {
                return "Response should not match Content-Type " + $contentType + ".";
            }
        };
    }

    @NotNull
    public static final Matcher<HttpResponse> haveHeader(@NotNull String headerName) {
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        return (Matcher)new Matcher<HttpResponse>(headerName){
            final /* synthetic */ String $headerName;
            {
                this.$headerName = $headerName;
            }

            public MatcherResult test(HttpResponse value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.getHeaders().contains(this.$headerName), () -> haveHeader.1.test$lambda$0(this.$headerName), () -> haveHeader.1.test$lambda$1(this.$headerName));
            }

            public Matcher<HttpResponse> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends HttpResponse> f) {
                return super.contramap(f);
            }

            public Matcher<HttpResponse> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(String $headerName) {
                return "Response should have " + $headerName + " header set.";
            }

            private static final String test$lambda$1(String $headerName) {
                return "Response should not have " + $headerName + " header set.";
            }
        };
    }

    @NotNull
    public static final Matcher<HttpResponse> haveHeader(@NotNull String headerName, @NotNull String headerValue) {
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        Intrinsics.checkNotNullParameter((Object)headerValue, (String)"headerValue");
        return (Matcher)new Matcher<HttpResponse>(headerName, headerValue){
            final /* synthetic */ String $headerName;
            final /* synthetic */ String $headerValue;
            {
                this.$headerName = $headerName;
                this.$headerValue = $headerValue;
            }

            public MatcherResult test(HttpResponse value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String actual = value.getHeaders().get(this.$headerName);
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)actual, (Object)this.$headerValue), () -> haveHeader.2.test$lambda$0(this.$headerName, this.$headerValue, actual), () -> haveHeader.2.test$lambda$1(this.$headerName, this.$headerValue));
            }

            public Matcher<HttpResponse> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends HttpResponse> f) {
                return super.contramap(f);
            }

            public Matcher<HttpResponse> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(String $headerName, String $headerValue, String $actual) {
                return "Response should have " + $headerName + ": " + $headerValue + " but had: " + $actual;
            }

            private static final String test$lambda$1(String $headerName, String $headerValue) {
                return "Response should not have " + $headerName + ": " + $headerValue + ".";
            }
        };
    }
}

