/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.resource;

import io.jstuff.text.SimpleMatcher;
import io.jstuff.text.StringMatcher;
import io.kjson.resource.Resource;
import io.kjson.resource.ResourceDescriptor;
import io.kjson.resource.SyntheticResource;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\b&\u0018\u0000 B*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0004?@ABB\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H&\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0006\u0010\u001f\u001a\u00020\u0004J!\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\u001b\u0010\u0015\u001a\u00028\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016\u00a2\u0006\u0002\u0010%J\u0013\u0010\u0015\u001a\u00028\u00002\u0006\u0010&\u001a\u00020\u0004\u00a2\u0006\u0002\u0010'J\u0013\u0010\u0015\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u0010\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0010J\u001c\u0010,\u001a\u00020-2\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bJ \u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00102\b\u00102\u001a\u0004\u0018\u00010\u0010J \u0010/\u001a\u00020-2\u0006\u00103\u001a\u0002042\u0006\u00101\u001a\u00020\u00102\b\u00102\u001a\u0004\u0018\u00010\u0010J*\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\u00102\b\b\u0002\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00102\b\b\u0002\u0010:\u001a\u000208J*\u00105\u001a\u00020-2\u0006\u0010;\u001a\u0002042\b\b\u0002\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00102\b\b\u0002\u0010:\u001a\u000208J\u0016\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR(\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006C"}, d2={"Lio/kjson/resource/ResourceLoader;", "T", "", "baseURL", "Ljava/net/URL;", "<init>", "(Ljava/net/URL;)V", "getBaseURL", "()Ljava/net/URL;", "connectionFilters", "", "Lkotlin/Function1;", "Ljava/net/URLConnection;", "getConnectionFilters$resource_loader", "()Ljava/util/List;", "defaultExtension", "", "getDefaultExtension", "()Ljava/lang/String;", "defaultMIMEType", "getDefaultMIMEType", "load", "rd", "Lio/kjson/resource/ResourceDescriptor;", "(Lio/kjson/resource/ResourceDescriptor;)Ljava/lang/Object;", "resource", "Lio/kjson/resource/Resource;", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "url", "syntheticResource", "Lio/kjson/resource/SyntheticResource;", "name", "value", "(Ljava/lang/String;Ljava/lang/Object;)Lio/kjson/resource/SyntheticResource;", "(Lio/kjson/resource/Resource;)Ljava/lang/Object;", "resourceURL", "(Ljava/net/URL;)Ljava/lang/Object;", "resourceId", "(Ljava/lang/String;)Ljava/lang/Object;", "addExtension", "s", "addConnectionFilter", "", "filter", "addAuthorizationFilter", "host", "headerName", "headerValue", "hostMatcher", "Lio/jstuff/text/StringMatcher;", "addRedirectionFilter", "fromHost", "fromPort", "", "toHost", "toPort", "fromHostMatcher", "addPrefixRedirectionFilter", "fromPrefix", "toPrefix", "AuthorizationFilter", "RedirectionFilter", "PrefixRedirectionFilter", "Companion", "resource-loader"})
public abstract class ResourceLoader<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL baseURL;
    @NotNull
    private final List<Function1<URLConnection, URLConnection>> connectionFilters;
    @Nullable
    private final String defaultExtension;
    @Nullable
    private final String defaultMIMEType;

    public ResourceLoader(@NotNull URL baseURL) {
        Intrinsics.checkNotNullParameter((Object)baseURL, (String)"baseURL");
        this.baseURL = baseURL;
        this.connectionFilters = new ArrayList();
    }

    public /* synthetic */ ResourceLoader(URL uRL, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uRL = Companion.defaultBaseURL();
        }
        this(uRL);
    }

    @NotNull
    public final URL getBaseURL() {
        return this.baseURL;
    }

    @NotNull
    public final List<Function1<URLConnection, URLConnection>> getConnectionFilters$resource_loader() {
        return this.connectionFilters;
    }

    @Nullable
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Nullable
    public String getDefaultMIMEType() {
        return this.defaultMIMEType;
    }

    public abstract T load(@NotNull ResourceDescriptor var1);

    @NotNull
    public final Resource<T> resource(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        URL uRL = file.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return new Resource(uRL, file.isDirectory(), this);
    }

    @NotNull
    public final Resource<T> resource(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URL uRL = path.toUri().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return new Resource(uRL, Files.isDirectory(path, new LinkOption[0]), this);
    }

    @NotNull
    public final Resource<T> resource(@NotNull URL url) {
        Resource<T> resource;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)url.getProtocol(), (Object)"file")) {
            resource = this.resource(new File(url.toURI()));
        } else {
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            resource = new Resource<T>(url, StringsKt.endsWith$default((CharSequence)string, (char)'/', (boolean)false, (int)2, null), this);
        }
        return resource;
    }

    @NotNull
    public final SyntheticResource<T> syntheticResource(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new SyntheticResource<T>(name, value, this);
    }

    public T load(@NotNull Resource<T> resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        return this.load(resource.open());
    }

    public final T load(@NotNull URL resourceURL) {
        Intrinsics.checkNotNullParameter((Object)resourceURL, (String)"resourceURL");
        return this.load(this.resource(resourceURL));
    }

    public final T load(@NotNull String resourceId) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        return this.load(new URL(this.baseURL, resourceId));
    }

    @NotNull
    public final String addExtension(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.getDefaultExtension() != null && StringsKt.indexOf$default((CharSequence)s, (char)'.', (int)(StringsKt.lastIndexOf$default((CharSequence)s, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null) + 1), (boolean)false, (int)4, null) < 0 ? s + '.' + this.getDefaultExtension() : s;
    }

    public final void addConnectionFilter(@NotNull Function1<? super URLConnection, ? extends URLConnection> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        this.connectionFilters.add(filter);
    }

    public final void addAuthorizationFilter(@NotNull String host, @NotNull String headerName, @Nullable String headerValue) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        SimpleMatcher simpleMatcher = StringMatcher.simple((String)host);
        Intrinsics.checkNotNullExpressionValue((Object)simpleMatcher, (String)"simple(...)");
        this.addConnectionFilter((Function1<URLConnection, URLConnection>)((Function1)new AuthorizationFilter((StringMatcher)simpleMatcher, headerName, headerValue)));
    }

    public final void addAuthorizationFilter(@NotNull StringMatcher hostMatcher, @NotNull String headerName, @Nullable String headerValue) {
        Intrinsics.checkNotNullParameter((Object)hostMatcher, (String)"hostMatcher");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        this.addConnectionFilter((Function1<URLConnection, URLConnection>)((Function1)new AuthorizationFilter(hostMatcher, headerName, headerValue)));
    }

    public final void addRedirectionFilter(@NotNull String fromHost, int fromPort, @NotNull String toHost, int toPort) {
        Intrinsics.checkNotNullParameter((Object)fromHost, (String)"fromHost");
        Intrinsics.checkNotNullParameter((Object)toHost, (String)"toHost");
        SimpleMatcher simpleMatcher = StringMatcher.simple((String)fromHost);
        Intrinsics.checkNotNullExpressionValue((Object)simpleMatcher, (String)"simple(...)");
        this.addConnectionFilter((Function1<URLConnection, URLConnection>)((Function1)new RedirectionFilter((StringMatcher)simpleMatcher, fromPort, toHost, toPort)));
    }

    public static /* synthetic */ void addRedirectionFilter$default(ResourceLoader resourceLoader, String string, int n, String string2, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addRedirectionFilter");
        }
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        resourceLoader.addRedirectionFilter(string, n, string2, n2);
    }

    public final void addRedirectionFilter(@NotNull StringMatcher fromHostMatcher, int fromPort, @NotNull String toHost, int toPort) {
        Intrinsics.checkNotNullParameter((Object)fromHostMatcher, (String)"fromHostMatcher");
        Intrinsics.checkNotNullParameter((Object)toHost, (String)"toHost");
        this.addConnectionFilter((Function1<URLConnection, URLConnection>)((Function1)new RedirectionFilter(fromHostMatcher, fromPort, toHost, toPort)));
    }

    public static /* synthetic */ void addRedirectionFilter$default(ResourceLoader resourceLoader, StringMatcher stringMatcher, int n, String string, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addRedirectionFilter");
        }
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        resourceLoader.addRedirectionFilter(stringMatcher, n, string, n2);
    }

    public final void addPrefixRedirectionFilter(@NotNull String fromPrefix, @NotNull String toPrefix) {
        Intrinsics.checkNotNullParameter((Object)fromPrefix, (String)"fromPrefix");
        Intrinsics.checkNotNullParameter((Object)toPrefix, (String)"toPrefix");
        this.addConnectionFilter((Function1<URLConnection, URLConnection>)((Function1)new PrefixRedirectionFilter(fromPrefix, toPrefix)));
    }

    public ResourceLoader() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0096\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0011"}, d2={"Lio/kjson/resource/ResourceLoader$AuthorizationFilter;", "Lkotlin/Function1;", "Ljava/net/URLConnection;", "hostMatcher", "Lio/jstuff/text/StringMatcher;", "headerName", "", "headerValue", "<init>", "(Lio/jstuff/text/StringMatcher;Ljava/lang/String;Ljava/lang/String;)V", "getHostMatcher", "()Lio/jstuff/text/StringMatcher;", "getHeaderName", "()Ljava/lang/String;", "getHeaderValue", "invoke", "connection", "resource-loader"})
    public static final class AuthorizationFilter
    implements Function1<URLConnection, URLConnection> {
        @NotNull
        private final StringMatcher hostMatcher;
        @NotNull
        private final String headerName;
        @Nullable
        private final String headerValue;

        public AuthorizationFilter(@NotNull StringMatcher hostMatcher, @NotNull String headerName, @Nullable String headerValue) {
            Intrinsics.checkNotNullParameter((Object)hostMatcher, (String)"hostMatcher");
            Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
            this.hostMatcher = hostMatcher;
            this.headerName = headerName;
            this.headerValue = headerValue;
        }

        @NotNull
        public final StringMatcher getHostMatcher() {
            return this.hostMatcher;
        }

        @NotNull
        public final String getHeaderName() {
            return this.headerName;
        }

        @Nullable
        public final String getHeaderValue() {
            return this.headerValue;
        }

        @NotNull
        public URLConnection invoke(@NotNull URLConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            if (connection instanceof HttpURLConnection && this.hostMatcher.matches((CharSequence)((HttpURLConnection)connection).getURL().getHost())) {
                connection.addRequestProperty(this.headerName, this.headerValue);
            }
            return connection;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lio/kjson/resource/ResourceLoader$Companion;", "", "<init>", "()V", "defaultBaseURL", "Ljava/net/URL;", "resource-loader"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URL defaultBaseURL() {
            URL uRL = new File(".").getCanonicalFile().toURI().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            return uRL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0096\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\r"}, d2={"Lio/kjson/resource/ResourceLoader$PrefixRedirectionFilter;", "Lkotlin/Function1;", "Ljava/net/URLConnection;", "fromPrefix", "", "toPrefix", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getFromPrefix", "()Ljava/lang/String;", "getToPrefix", "invoke", "connection", "resource-loader"})
    public static final class PrefixRedirectionFilter
    implements Function1<URLConnection, URLConnection> {
        @NotNull
        private final String fromPrefix;
        @NotNull
        private final String toPrefix;

        public PrefixRedirectionFilter(@NotNull String fromPrefix, @NotNull String toPrefix) {
            Intrinsics.checkNotNullParameter((Object)fromPrefix, (String)"fromPrefix");
            Intrinsics.checkNotNullParameter((Object)toPrefix, (String)"toPrefix");
            this.fromPrefix = fromPrefix;
            this.toPrefix = toPrefix;
        }

        @NotNull
        public final String getFromPrefix() {
            return this.fromPrefix;
        }

        @NotNull
        public final String getToPrefix() {
            return this.toPrefix;
        }

        @NotNull
        public URLConnection invoke(@NotNull URLConnection connection) {
            URLConnection uRLConnection;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            String it = connection.getURL().toString();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (StringsKt.startsWith$default((String)it, (String)this.fromPrefix, (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append(this.toPrefix);
                String string = it.substring(this.fromPrefix.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                uRLConnection = new URL(stringBuilder.append(string).toString()).openConnection();
            } else {
                uRLConnection = connection;
            }
            Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"let(...)");
            return uRLConnection;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002H\u0096\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lio/kjson/resource/ResourceLoader$RedirectionFilter;", "Lkotlin/Function1;", "Ljava/net/URLConnection;", "fromHostMatcher", "Lio/jstuff/text/StringMatcher;", "fromPort", "", "toHost", "", "toPort", "<init>", "(Lio/jstuff/text/StringMatcher;ILjava/lang/String;I)V", "getFromHostMatcher", "()Lio/jstuff/text/StringMatcher;", "getFromPort", "()I", "getToHost", "()Ljava/lang/String;", "getToPort", "invoke", "connection", "resource-loader"})
    public static final class RedirectionFilter
    implements Function1<URLConnection, URLConnection> {
        @NotNull
        private final StringMatcher fromHostMatcher;
        private final int fromPort;
        @NotNull
        private final String toHost;
        private final int toPort;

        public RedirectionFilter(@NotNull StringMatcher fromHostMatcher, int fromPort, @NotNull String toHost, int toPort) {
            Intrinsics.checkNotNullParameter((Object)fromHostMatcher, (String)"fromHostMatcher");
            Intrinsics.checkNotNullParameter((Object)toHost, (String)"toHost");
            this.fromHostMatcher = fromHostMatcher;
            this.fromPort = fromPort;
            this.toHost = toHost;
            this.toPort = toPort;
        }

        public /* synthetic */ RedirectionFilter(StringMatcher stringMatcher, int n, String string, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = -1;
            }
            if ((n3 & 8) != 0) {
                n2 = -1;
            }
            this(stringMatcher, n, string, n2);
        }

        @NotNull
        public final StringMatcher getFromHostMatcher() {
            return this.fromHostMatcher;
        }

        public final int getFromPort() {
            return this.fromPort;
        }

        @NotNull
        public final String getToHost() {
            return this.toHost;
        }

        public final int getToPort() {
            return this.toPort;
        }

        @NotNull
        public URLConnection invoke(@NotNull URLConnection connection) {
            URLConnection uRLConnection;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            URL url = connection.getURL();
            if (!(connection instanceof HttpURLConnection) || !this.fromHostMatcher.matches((CharSequence)url.getHost()) || url.getPort() != this.fromPort) {
                uRLConnection = connection;
            } else {
                URLConnection uRLConnection2 = new URL(url.getProtocol(), this.toHost, this.toPort, url.getFile()).openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection2, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                uRLConnection = (HttpURLConnection)uRLConnection2;
            }
            return uRLConnection;
        }
    }
}

