/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.models.service.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.keyko.common.helpers.EthereumHelper;
import io.keyko.nevermined.models.service.Condition;
import io.keyko.nevermined.models.service.Service;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.web3j.crypto.Hash;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(alphabetic=true)
public class AccessService
extends Service {
    @JsonIgnore
    public static final int DEFAULT_INDEX = 3;

    public AccessService() {
        this.index = 3;
        this.type = Service.ServiceTypes.ACCESS.toString();
    }

    public AccessService(String serviceEndpoint, int index, String templateId) {
        super(Service.ServiceTypes.ACCESS, serviceEndpoint, index);
        this.type = Service.ServiceTypes.ACCESS.toString();
        this.templateId = templateId;
    }

    public AccessService(String serviceEndpoint, int index, Service.ServiceAgreementTemplate serviceAgreementTemplate, String templateId) {
        super(Service.ServiceTypes.ACCESS, serviceEndpoint, index);
        this.type = Service.ServiceTypes.ACCESS.toString();
        this.templateId = templateId;
        this.attributes.serviceAgreementTemplate = serviceAgreementTemplate;
    }

    public String generateAccessSecretStoreConditionId(String serviceAgreementId, String consumerAddress, String accessSecretStoreConditionAddress) throws UnsupportedEncodingException {
        Condition accessSecretStoreCondition = this.getConditionbyName("accessSecretStore");
        Condition.ConditionParameter documentId = accessSecretStoreCondition.getParameterByName("_documentId");
        Condition.ConditionParameter grantee = accessSecretStoreCondition.getParameterByName("_grantee");
        String params = EthereumHelper.add0x((String)(EthereumHelper.encodeParameterValue((String)documentId.type, (Object)documentId.value) + EthereumHelper.encodeParameterValue((String)grantee.type, (Object)consumerAddress)));
        String valuesHash = Hash.sha3((String)params);
        return Hash.sha3((String)EthereumHelper.add0x((String)(EthereumHelper.encodeParameterValue((String)"bytes32", (Object)serviceAgreementId) + EthereumHelper.encodeParameterValue((String)"address", (Object)accessSecretStoreConditionAddress) + EthereumHelper.encodeParameterValue((String)"bytes32", (Object)valuesHash))));
    }

    @Override
    public List<String> generateConditionIds(String agreementId, Map<String, String> conditionsAddresses, String publisherAddress, String consumerAddress) throws Exception {
        String escrowRewardAddress = conditionsAddresses.get("escrowRewardAddress");
        String lockRewardConditionAddress = conditionsAddresses.get("lockRewardConditionAddress");
        String accessSecretStoreConditionAddress = conditionsAddresses.get("accessSecretStoreConditionAddress");
        ArrayList<String> conditionIds = new ArrayList<String>();
        String lockRewardId = this.generateLockRewardId(agreementId, escrowRewardAddress, lockRewardConditionAddress);
        String accessSecretStoreId = this.generateAccessSecretStoreConditionId(agreementId, consumerAddress, accessSecretStoreConditionAddress);
        String escrowRewardId = this.generateEscrowRewardConditionId(agreementId, consumerAddress, publisherAddress, escrowRewardAddress, lockRewardId, accessSecretStoreId);
        conditionIds.add(accessSecretStoreId);
        conditionIds.add(lockRewardId);
        conditionIds.add(escrowRewardId);
        return conditionIds;
    }
}

