/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.models.service.metadata;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.keyko.nevermined.exceptions.DIDFormatException;
import io.keyko.nevermined.models.DID;
import io.keyko.nevermined.models.asset.AssetMetadata;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(alphabetic=true)
public class Workflow {
    @JsonProperty
    public List<Stage> stages;

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    public static class Output {
        @JsonProperty
        public String metadataUrl;
        @JsonProperty
        public String secretStoreUrl;
        @JsonProperty
        public String accessProxyUrl;
        @JsonProperty
        public AssetMetadata metadata;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    public static class Transformation {
        @JsonProperty
        public DID id;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    public static class Input {
        @JsonProperty
        public Integer index;
        @JsonProperty
        public DID id;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    public static class Container {
        @JsonProperty
        public String image;
        @JsonProperty
        public String tag;
        @JsonProperty
        public String checksum;

        public static Container parseString(String containerLine) {
            String[] containerTokens = containerLine.split(":");
            Container container = new Container();
            container.image = containerTokens[0];
            container.tag = containerTokens.length > 1 ? containerTokens[1] : "latest";
            return container;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    public static class Requirements {
        @JsonProperty
        public Container container;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    public static class Stage {
        @JsonProperty
        public Integer index;
        @JsonProperty
        public String stageType;
        @JsonProperty
        public Requirements requirements;
        @JsonProperty
        public List<Input> input;
        @JsonProperty
        public Transformation transformation;
        @JsonProperty
        public Output output;

        public static List<Input> parseInputs(String stringInputs) {
            String[] inputs = stringInputs.split(",");
            ArrayList<Input> listInputs = new ArrayList<Input>();
            for (String entry : inputs) {
                try {
                    Input input = new Input();
                    input.id = new DID(entry);
                    listInputs.add(input);
                }
                catch (DIDFormatException dIDFormatException) {
                    // empty catch block
                }
            }
            return listInputs;
        }
    }
}

