/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.models.service;

import io.keyko.nevermined.exceptions.DDOException;
import io.keyko.nevermined.exceptions.ServiceException;
import io.keyko.nevermined.models.service.Condition;
import io.keyko.nevermined.models.service.ProviderConfig;
import io.keyko.nevermined.models.service.Service;
import io.keyko.nevermined.models.service.types.AccessService;
import io.keyko.nevermined.models.service.types.ComputingService;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public interface ServiceBuilder {
    public Service buildService(Map<String, Object> var1) throws DDOException;

    public static ServiceBuilder getServiceBuilder(Service.ServiceTypes serviceType) throws ServiceException {
        switch (serviceType) {
            case ACCESS: {
                return ServiceBuilder.accessServiceBuilder();
            }
            case COMPUTE: {
                return ServiceBuilder.computingServiceBuilder();
            }
        }
        throw new ServiceException("Invalid Service definition");
    }

    private static ServiceBuilder computingServiceBuilder() {
        return config -> {
            ProviderConfig providerConfig = (ProviderConfig)config.get("providerConfig");
            ComputingService.Provider computingProvider = (ComputingService.Provider)config.get("computingProvider");
            String computingServiceTemplateId = (String)config.get("computingServiceTemplateId");
            String price = (String)config.get("price");
            String creator = (String)config.get("creator");
            return ServiceBuilder.buildComputingService(providerConfig, computingProvider, computingServiceTemplateId, price, creator);
        };
    }

    private static ComputingService buildComputingService(ProviderConfig providerConfig, ComputingService.Provider computingProvider, String computingServiceTemplateId, String price, String creator) throws DDOException {
        Service.ServiceAgreementTemplate serviceAgreementTemplate = new Service.ServiceAgreementTemplate();
        serviceAgreementTemplate.contractName = "EscrowComputeExecutionTemplate";
        serviceAgreementTemplate.fulfillmentOrder = Arrays.asList("lockReward.fulfill", "execCompute.fulfill", "escrowReward.fulfill");
        Condition.Event executeAgreementEvent = new Condition.Event();
        executeAgreementEvent.name = "AgreementCreated";
        executeAgreementEvent.actorType = "consumer";
        Condition.Handler handler = new Condition.Handler();
        handler.moduleName = "EscrowComputeExecutionTemplate";
        handler.functionName = "fulfillLockRewardCondition";
        handler.version = "0.1";
        executeAgreementEvent.handler = handler;
        Service.ConditionDependency conditionDependency = new Service.ConditionDependency();
        conditionDependency.escrowReward = Service.ConditionDependency.defaultComputeEscrowReward();
        conditionDependency.accessSecretStore = null;
        serviceAgreementTemplate.conditionDependency = conditionDependency;
        serviceAgreementTemplate.events = Arrays.asList(executeAgreementEvent);
        ComputingService computingService = new ComputingService(providerConfig.getAccessEndpoint(), 4, serviceAgreementTemplate, computingServiceTemplateId);
        computingService.attributes.main.provider = computingProvider;
        computingService.attributes.main.name = "dataAssetComputeServiceAgreement";
        computingService.attributes.main.price = price;
        computingService.attributes.main.creator = creator;
        computingService.attributes.main.datePublished = new Date();
        return computingService;
    }

    private static ServiceBuilder accessServiceBuilder() {
        return config -> {
            ProviderConfig providerConfig = (ProviderConfig)config.get("providerConfig");
            String accessServiceTemplateId = (String)config.get("accessServiceTemplateId");
            String price = (String)config.get("price");
            String creator = (String)config.get("creator");
            return ServiceBuilder.buildAccessService(providerConfig, accessServiceTemplateId, price, creator);
        };
    }

    private static AccessService buildAccessService(ProviderConfig providerConfig, String accessServiceTemplateId, String price, String creator) {
        Service.ServiceAgreementTemplate serviceAgreementTemplate = new Service.ServiceAgreementTemplate();
        serviceAgreementTemplate.contractName = "EscrowAccessSecretStoreTemplate";
        Condition.Event executeAgreementEvent = new Condition.Event();
        executeAgreementEvent.name = "AgreementCreated";
        executeAgreementEvent.actorType = "consumer";
        Condition.Handler handler = new Condition.Handler();
        handler.moduleName = "escrowAccessSecretStoreTemplate";
        handler.functionName = "fulfillLockRewardCondition";
        handler.version = "0.1";
        executeAgreementEvent.handler = handler;
        serviceAgreementTemplate.events = Arrays.asList(executeAgreementEvent);
        AccessService accessService = new AccessService(providerConfig.getAccessEndpoint(), 3, serviceAgreementTemplate, accessServiceTemplateId);
        accessService.attributes.main.name = "dataAssetAccessServiceAgreement";
        accessService.attributes.main.price = price;
        accessService.attributes.main.creator = creator;
        accessService.attributes.main.datePublished = new Date();
        return accessService;
    }

    public static Map<String, Object> getAccessConditionParams(String did, String price, String escrowRewardAddress, String lockRewardConditionAddress, String accessSecretStoreConditionAddress) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parameter.did", did);
        params.put("parameter.price", price);
        params.put("contract.EscrowReward.address", escrowRewardAddress);
        params.put("contract.LockRewardCondition.address", lockRewardConditionAddress);
        params.put("contract.AccessSecretStoreCondition.address", accessSecretStoreConditionAddress);
        params.put("parameter.assetId", did.replace("did:nv:", ""));
        return params;
    }

    public static Map<String, Object> getComputingConditionParams(String did, String price, String escrowRewardAddress, String lockRewardConditionAddress, String execComputeConditionAddress) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parameter.did", did);
        params.put("parameter.price", price);
        params.put("contract.EscrowReward.address", escrowRewardAddress);
        params.put("contract.LockRewardCondition.address", lockRewardConditionAddress);
        params.put("contract.ExecComputeCondition.address", execComputeConditionAddress);
        params.put("parameter.assetId", did.replace("did:nv:", ""));
        return params;
    }
}

