/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.models.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.keyko.nevermined.models.AbstractModel;
import io.keyko.nevermined.models.FromJsonToModel;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(alphabetic=true)
public class Condition
extends AbstractModel
implements FromJsonToModel {
    @JsonProperty
    public String name;
    @JsonProperty
    public int timelock;
    @JsonProperty
    public int timeout;
    @JsonProperty
    public String contractName;
    @JsonProperty
    public String functionName;
    @JsonProperty
    public List<ConditionParameter> parameters = new ArrayList<ConditionParameter>();
    @JsonProperty
    public List<Event> events = new ArrayList<Event>();

    public ConditionParameter getParameterByName(String name) {
        return this.parameters.stream().filter(parameter -> parameter.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    public static class ConditionParameter {
        @JsonProperty
        public String name;
        @JsonProperty
        public String type;
        @JsonProperty
        public Object value;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    public static class Handler {
        @JsonProperty
        public String moduleName;
        @JsonProperty
        public String functionName;
        @JsonProperty
        public String version;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    public static class Event {
        @JsonProperty
        public String name;
        @JsonProperty
        public String actorType;
        @JsonProperty
        public Handler handler;
    }

    public static enum ConditionTypes {
        lockReward,
        accessSecretStore,
        escrowReward,
        hashLock,
        whitelisting,
        threshold,
        sign,
        execCompute;

    }
}

