/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.models.service;

import io.keyko.nevermined.external.GatewayService;
import io.keyko.nevermined.models.gateway.Status;
import io.keyko.nevermined.models.service.types.AuthorizationService;
import java.io.IOException;

public class AuthConfig {
    private String serviceEndpoint;
    private AuthorizationService.AuthTypes service;
    private String publicKey = "";
    private int threshold = 0;

    public AuthConfig(String serviceEndpoint) {
        this(serviceEndpoint, AuthorizationService.DEFAULT_SERVICE);
    }

    public AuthConfig(String serviceEndpoint, AuthorizationService.AuthTypes service) {
        this.serviceEndpoint = serviceEndpoint;
        this.service = service;
        try {
            Status status = GatewayService.getStatus(serviceEndpoint);
            if (this.service.equals((Object)AuthorizationService.AuthTypes.PSK_RSA)) {
                this.publicKey = status.rsaPublicKey;
            } else if (this.service.equals((Object)AuthorizationService.AuthTypes.PSK_ECDSA)) {
                this.publicKey = status.ecdsaPublicKey;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public AuthConfig setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public AuthorizationService.AuthTypes getService() {
        return this.service;
    }

    public AuthConfig setService(AuthorizationService.AuthTypes service) {
        this.service = service;
        return this;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public AuthConfig setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public AuthConfig setThreshold(int threshold) {
        this.threshold = threshold;
        return this;
    }
}

