/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import io.keyko.common.helpers.CryptoHelper;
import io.keyko.common.helpers.EthereumHelper;
import io.keyko.nevermined.exceptions.DIDFormatException;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DID {
    public String did;
    public static final String PREFIX = "did:nv:";

    public DID() {
        this.setEmptyDID();
    }

    public DID(String did) throws DIDFormatException {
        this.setDid(did);
    }

    public static DID builder(String seed) throws DIDFormatException {
        DID _did = new DID(PREFIX + EthereumHelper.remove0x((String)CryptoHelper.sha3_256((String)seed)));
        _did.setDid(_did.getDid());
        return _did;
    }

    public static DID builder() throws DIDFormatException {
        return new DID(DID.generateRandomToken());
    }

    public static DID getFromHash(String hash) throws DIDFormatException {
        return new DID(PREFIX + hash);
    }

    @JsonValue
    public String getDid() {
        return this.did;
    }

    public String getHash() {
        return this.did.substring(PREFIX.length());
    }

    public static String generateRandomToken() {
        String token = PREFIX + UUID.randomUUID().toString() + UUID.randomUUID().toString();
        return token.replaceAll("-", "");
    }

    public String toString() {
        return this.did;
    }

    public DID setEmptyDID() {
        this.did = "";
        return this;
    }

    public DID setDid(String did) throws DIDFormatException {
        if (!did.startsWith(PREFIX)) {
            throw new DIDFormatException("Invalid DID Format, it should starts by did:nv:");
        }
        this.did = did;
        return this;
    }
}

