/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.models;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.api.client.util.Base64;
import io.keyko.common.helpers.EncodingHelper;
import io.keyko.common.helpers.EthereumHelper;
import io.keyko.nevermined.exceptions.DDOException;
import io.keyko.nevermined.exceptions.DIDFormatException;
import io.keyko.nevermined.exceptions.ServiceException;
import io.keyko.nevermined.external.GatewayService;
import io.keyko.nevermined.manager.SecretStoreManager;
import io.keyko.nevermined.models.AbstractModel;
import io.keyko.nevermined.models.CustomDateDeserializer;
import io.keyko.nevermined.models.DID;
import io.keyko.nevermined.models.FromJsonToModel;
import io.keyko.nevermined.models.gateway.EncryptionResponse;
import io.keyko.nevermined.models.service.AuthConfig;
import io.keyko.nevermined.models.service.Service;
import io.keyko.nevermined.models.service.types.AccessService;
import io.keyko.nevermined.models.service.types.AuthorizationService;
import io.keyko.nevermined.models.service.types.ComputingService;
import io.keyko.nevermined.models.service.types.DDOServiceIndexSorter;
import io.keyko.nevermined.models.service.types.MetadataService;
import io.keyko.nevermined.models.service.types.ProvenanceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;

@JsonPropertyOrder(alphabetic=true)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DDO
extends AbstractModel
implements FromJsonToModel {
    private static final Logger log = LogManager.getLogger(DDO.class);
    private static final String UUID_PROOF_TYPE = "DDOIntegritySignature";
    private static final String AUTHENTICATION_TYPE = "RsaSignatureAuthentication2018";
    @JsonProperty(value="@context")
    public String context = "https://w3id.org/did/v1";
    @JsonProperty
    public String id;
    @JsonIgnore
    private DID did;
    @JsonProperty(value="publicKey")
    public List<PublicKey> publicKeys = new ArrayList<PublicKey>();
    @JsonProperty
    public List<Authentication> authentication = new ArrayList<Authentication>();
    @JsonIgnore
    public List<Service> services = new ArrayList<Service>();
    @JsonProperty
    public Proof proof;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    @JsonDeserialize(using=CustomDateDeserializer.class)
    public Date created;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    @JsonProperty
    public Date updated;

    public DDO() {
        this.did = null;
        if (null == this.created) {
            this.created = DDO.getDateNowFormatted();
        }
        if (null == this.updated) {
            this.updated = DDO.getDateNowFormatted();
        }
        this.id = "{did}";
    }

    public DDO(MetadataService metadataService, String publicKey, String signature) throws DIDFormatException {
        if (null == this.created) {
            this.created = DDO.getDateNowFormatted();
        }
        if (null == this.updated) {
            this.updated = this.created;
        }
        this.services.add(metadataService);
        this.proof = new Proof(UUID_PROOF_TYPE, publicKey, signature);
        this.publicKeys.add(new PublicKey(publicKey, "EthereumECDSAKey", publicKey));
    }

    @JsonSetter(value="id")
    public void didSetter(String id) throws DIDFormatException {
        this.id = id;
        this.did = new DID(id);
    }

    public DDO addAuthentication(String id) {
        this.authentication.add(new Authentication(id));
        return this;
    }

    private void sortServices() {
        Collections.sort(this.services, new DDOServiceIndexSorter());
    }

    public DDO addService(Service service) {
        this.services.add(service);
        return this;
    }

    @JsonSetter(value="service")
    public void servicesSetter(ArrayList<LinkedHashMap> services) {
        try {
            for (LinkedHashMap service : services) {
                if (!service.containsKey("type")) continue;
                if (service.get("type").equals(Service.ServiceTypes.METADATA.toString()) && service.containsKey("metadata")) {
                    this.services.add((Service)DDO.getMapperInstance().convertValue((Object)service, MetadataService.class));
                    continue;
                }
                if (service.get("type").equals(Service.ServiceTypes.PROVENANCE.toString())) {
                    this.services.add((Service)DDO.getMapperInstance().convertValue((Object)service, ProvenanceService.class));
                    continue;
                }
                if (service.get("type").equals(Service.ServiceTypes.ACCESS.toString())) {
                    this.services.add((Service)DDO.getMapperInstance().convertValue((Object)service, AccessService.class));
                    continue;
                }
                if (service.get("type").equals(Service.ServiceTypes.COMPUTE.toString())) {
                    this.services.add((Service)DDO.getMapperInstance().convertValue((Object)service, ComputingService.class));
                    continue;
                }
                if (service.get("type").equals(Service.ServiceTypes.AUTHORIZATION.toString())) {
                    this.services.add((Service)DDO.getMapperInstance().convertValue((Object)service, AuthorizationService.class));
                    continue;
                }
                this.services.add((Service)DDO.getMapperInstance().convertValue((Object)service, Service.class));
            }
        }
        catch (Exception ex) {
            log.error("Unable to parse the DDO(services): " + services + ", Exception: " + ex.getMessage());
        }
    }

    @JsonGetter(value="service")
    public List<Service> servicesGetter() {
        int counter = 0;
        for (Service service : this.services) {
            if (service.type == null) continue;
            this.services.set(counter, service);
            ++counter;
        }
        return this.services;
    }

    public DDO integrityBuilder(Credentials credentials) throws DDOException {
        try {
            this.sortServices();
            this.proof.checksum = this.generateChecksums();
            this.did = DID.builder(this.toJson(this.proof.checksum));
            this.id = this.did.getDid();
            Sign.SignatureData signatureData = EthereumHelper.signMessage((String)this.id, (Credentials)credentials);
            this.proof.signatureValue = EncodingHelper.signatureToString((Sign.SignatureData)signatureData);
            this.proof.creator = Keys.toChecksumAddress((String)credentials.getAddress());
            this.proof.created = DDO.getDateNowFormatted();
            String ddoJson = this.toJson();
            return DDO.fromJSON(new TypeReference<DDO>(){}, ddoJson.replaceAll("\\{did}", this.id));
        }
        catch (Exception ex) {
            throw new DDOException("Unable to generate service checksum: " + ex.getMessage());
        }
    }

    public DDO secretStoreLocalEncryptFiles(SecretStoreManager secretStoreManager, AuthConfig authConfig) throws DDOException {
        try {
            Service metadataService = this.getMetadataService();
            AuthorizationService authService = this.getAuthorizationService();
            String filesJson = metadataService.toJson(metadataService.attributes.main.files);
            EncryptionResponse encryptionResponse = GatewayService.encrypt(authConfig.getServiceEndpoint(), filesJson, authConfig.getService());
            metadataService.attributes.encryptedFiles = encryptionResponse.hash;
            authService.attributes.main.publicKey = encryptionResponse.publicKey;
        }
        catch (JsonProcessingException | ServiceException e) {
            throw new DDOException("Unable to encrypt files using SecretStore: " + e.getMessage(), e);
        }
        return this;
    }

    public DDO gatewayEncryptFiles(AuthConfig authConfig) throws DDOException {
        try {
            Service metadataService = this.getMetadataService();
            AuthorizationService authService = this.getAuthorizationService();
            String filesJson = metadataService.toJson(metadataService.attributes.main.files);
            EncryptionResponse encryptionResponse = GatewayService.encrypt(authConfig.getServiceEndpoint(), filesJson, authConfig.getService());
            metadataService.attributes.encryptedFiles = encryptionResponse.hash;
            authService.attributes.main.publicKey = encryptionResponse.publicKey;
        }
        catch (JsonProcessingException | ServiceException e) {
            throw new DDOException("Unable to encrypt files via Gateway: " + e.getMessage(), e);
        }
        return this;
    }

    public DDO setEncryptedFiles(String hash) {
        Service metadataService = this.getMetadataService();
        metadataService.attributes.encryptedFiles = hash;
        return this;
    }

    public SortedMap<String, String> generateChecksums() throws DDOException {
        TreeMap<String, String> checksums = new TreeMap<String, String>();
        try {
            for (Service service : this.services) {
                checksums.put(String.valueOf(service.index), service.attributes.main.checksum());
            }
        }
        catch (Exception ex) {
            throw new DDOException("Unable to generate service checksum: " + ex.getMessage());
        }
        return checksums;
    }

    public static DID generateDID() throws DIDFormatException {
        DID did = DID.builder();
        log.debug("Id generated: " + did.toString());
        return did;
    }

    public DID getDid() {
        return this.did;
    }

    public AccessService getAccessService(int index) throws ServiceException {
        for (Service service : this.services) {
            if (service.index != index || !service.type.equals(Service.ServiceTypes.ACCESS.toString())) continue;
            return (AccessService)service;
        }
        throw new ServiceException("Access Service with index=" + index + " not found");
    }

    @JsonIgnore
    public Service getService(int index) throws ServiceException {
        return this.services.stream().filter(s -> s.index == index).findFirst().orElseThrow(() -> new ServiceException("Service with index=" + index + " not found"));
    }

    @JsonIgnore
    public Service getServiceByTemplate(String templateId) throws ServiceException {
        return this.services.stream().filter(s -> s.templateId == templateId).findFirst().orElseThrow(() -> new ServiceException("Service with template=" + templateId + " not found"));
    }

    @JsonIgnore
    public AuthorizationService getAuthorizationService(int serviceDefinitionId) {
        for (Service service : this.services) {
            if (service.index != serviceDefinitionId || !service.type.equals(Service.ServiceTypes.AUTHORIZATION.toString())) continue;
            return (AuthorizationService)service;
        }
        return null;
    }

    @JsonIgnore
    public AuthorizationService getAuthorizationService() {
        for (Service service : this.services) {
            if (!service.type.equals(Service.ServiceTypes.AUTHORIZATION.toString())) continue;
            return (AuthorizationService)service;
        }
        return null;
    }

    @JsonIgnore
    public Service getMetadataService() {
        for (Service service : this.services) {
            if (!service.type.equals(Service.ServiceTypes.METADATA.toString())) continue;
            return service;
        }
        return null;
    }

    @JsonIgnore
    public AccessService getAccessService() {
        for (Service service : this.services) {
            if (!service.type.equals(Service.ServiceTypes.ACCESS.toString())) continue;
            return (AccessService)service;
        }
        return null;
    }

    @JsonIgnore
    public ComputingService getComputeService() {
        for (Service service : this.services) {
            if (!service.type.equals(Service.ServiceTypes.COMPUTE.toString())) continue;
            return (ComputingService)service;
        }
        return null;
    }

    @JsonIgnore
    public static DDO cleanFileUrls(DDO ddo) {
        ddo.services.forEach(service -> {
            if (service.type.equals(Service.ServiceTypes.METADATA.toString())) {
                service.attributes.main.files.forEach(f -> {
                    f.url = null;
                });
            }
        });
        return ddo;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    public static class Proof {
        @JsonProperty
        public String type;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
        @JsonDeserialize(using=CustomDateDeserializer.class)
        public Date created;
        @JsonProperty
        public String creator;
        @JsonProperty
        public String signatureValue;
        @JsonProperty
        public Map<String, String> checksum;

        public Proof() {
        }

        public Proof(String type, String creator, String signature) {
            this.type = type;
            this.creator = creator;
            this.signatureValue = signature;
            this.created = AbstractModel.getDateNowFormatted();
        }

        public Proof(String type, String creator, byte[] signature) {
            this(type, creator, Base64.encodeBase64URLSafeString((byte[])signature));
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    static class Authentication {
        @JsonProperty
        public String type;
        @JsonProperty
        public String publicKey;

        public Authentication() {
        }

        public Authentication(String id) {
            this.publicKey = id;
            this.type = DDO.AUTHENTICATION_TYPE;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(alphabetic=true)
    static class PublicKey {
        public static final String ETHEREUM_KEY_TYPE = "EthereumECDSAKey";
        @JsonProperty
        public String id;
        @JsonProperty
        public String type;
        @JsonProperty
        public String owner;
        @JsonProperty
        public String publicKeyPem;
        @JsonProperty
        public String publicKeyBase58;

        public PublicKey() {
        }

        public PublicKey(String id, String type, String owner) {
            this.id = id;
            this.type = type;
            this.owner = owner;
        }
    }
}

