/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.models;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CustomDateDeserializer
extends StdDeserializer<Date> {
    public static final String ALT_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private SimpleDateFormat formatter = this.initializeFormatter("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private SimpleDateFormat altFormatter = this.initializeFormatter("yyyy-MM-dd'T'HH:mm:ss");

    private SimpleDateFormat initializeFormatter(String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter;
    }

    public CustomDateDeserializer() {
        this(null);
    }

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String date = jsonParser.getText();
        try {
            return this.formatter.parse(date);
        }
        catch (ParseException e) {
            try {
                return this.altFormatter.parse(date);
            }
            catch (ParseException e2) {
                throw new IOException(e);
            }
        }
    }

    public CustomDateDeserializer(Class<?> vc) {
        super(vc);
    }
}

