/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.models;

import java.math.BigDecimal;
import java.math.BigInteger;

public class Balance {
    private BigInteger eth;
    private BigInteger drops;

    public Balance() {
        this.eth = BigInteger.valueOf(0L);
        this.drops = BigInteger.valueOf(0L);
    }

    public Balance(BigInteger eth, BigInteger drops) {
        this.eth = eth;
        this.drops = drops;
    }

    public BigInteger getEth() {
        return this.eth;
    }

    public BigInteger getDrops() {
        return this.drops;
    }

    public BigDecimal getNeverminedTokens() {
        return Balance.dropsToNevermined(this.drops);
    }

    public static BigDecimal dropsToNevermined(BigInteger drops) {
        return new BigDecimal(drops).divide(new BigDecimal(Unit.NVN.factor));
    }

    public static BigInteger neverminedToDrops(BigInteger nevermined) {
        return nevermined.multiply(Unit.NVN.factor);
    }

    public String toString() {
        return "Balance{eth=" + this.eth + ", drops=" + this.drops + "}";
    }

    public static enum Unit {
        DROP("drop", 0),
        VODKA("vodka", 0),
        NVN("nvn", 18);

        private String name;
        private BigInteger factor;

        private Unit(String name, int factor) {
            this.name = name;
            this.factor = BigInteger.TEN.pow(factor);
        }
    }
}

