/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.manager;

import io.keyko.common.web3.KeeperService;
import io.keyko.nevermined.exceptions.EthereumException;
import io.keyko.nevermined.external.MetadataApiService;
import io.keyko.nevermined.manager.BaseManager;
import io.keyko.nevermined.models.service.template.TemplateSEA;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple4;

public class TemplatesManager
extends BaseManager {
    private static final Logger log = LogManager.getLogger(TemplatesManager.class);

    private TemplatesManager(KeeperService keeperService, MetadataApiService metadataApiService) {
        super(keeperService, metadataApiService);
    }

    public static TemplatesManager getInstance(KeeperService keeperService, MetadataApiService metadataApiService) {
        return new TemplatesManager(keeperService, metadataApiService);
    }

    public TransactionReceipt proposeTemplate(String templateAddress) throws EthereumException {
        try {
            log.debug("TemplateStoreManager - Propose - Owner: " + (String)this.templateStoreManager.owner().send());
            return (TransactionReceipt)this.templateStoreManager.proposeTemplate(templateAddress).send();
        }
        catch (Exception ex) {
            String msg = "Error proposing template " + templateAddress;
            log.error(msg + ": " + ex.getMessage());
            throw new EthereumException(msg, ex);
        }
    }

    public TransactionReceipt approveTemplate(String templateId) throws EthereumException {
        try {
            log.debug("TemplateStoreManager - Approve - Owner: " + (String)this.templateStoreManager.owner().send());
            return (TransactionReceipt)this.templateStoreManager.approveTemplate(templateId).send();
        }
        catch (Exception ex) {
            String msg = "Error approving template " + templateId;
            log.error(msg + ": " + ex.getMessage());
            throw new EthereumException(msg, ex);
        }
    }

    public TransactionReceipt revokeTemplate(String templateId) throws EthereumException {
        try {
            return (TransactionReceipt)this.templateStoreManager.revokeTemplate(templateId).send();
        }
        catch (Exception ex) {
            String msg = "Error proposing template " + templateId;
            log.error(msg + ": " + ex.getMessage());
            throw new EthereumException(msg, ex);
        }
    }

    public boolean isTemplateApproved(String templateAddress) throws EthereumException {
        try {
            return (Boolean)this.templateStoreManager.isTemplateApproved(templateAddress).send();
        }
        catch (Exception ex) {
            String msg = "Error checking if template " + templateAddress + " is approved";
            log.error(msg + ": " + ex.getMessage());
            throw new EthereumException(msg, ex);
        }
    }

    public BigInteger getTemplateListSize() throws EthereumException {
        try {
            return (BigInteger)this.templateStoreManager.getTemplateListSize().send();
        }
        catch (Exception ex) {
            String msg = "Error getting the number of existing templates";
            log.error(msg + ": " + ex.getMessage());
            throw new EthereumException(msg, ex);
        }
    }

    public TemplateSEA getTemplate(String templateId) throws EthereumException {
        try {
            Tuple4 tuple = (Tuple4)this.templateStoreManager.getTemplate(templateId).send();
            return new TemplateSEA((BigInteger)tuple.getValue1(), (String)tuple.getValue2(), (String)tuple.getValue3(), (BigInteger)tuple.getValue4());
        }
        catch (Exception ex) {
            String msg = "Error getting template " + templateId;
            log.error(msg + ": " + ex.getMessage());
            throw new EthereumException(msg, ex);
        }
    }
}

